/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.util.Log;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class FlickrPOIProvider {
    protected String mApiKey;

    public FlickrPOIProvider(String apiKey) {
        this.mApiKey = apiKey;
    }

    private String getUrlInside(BoundingBox boundingBox, int maxResults) {
        StringBuilder url = new StringBuilder("https://api.flickr.com/services/rest/?method=flickr.photos.search");
        url.append("&api_key=" + this.mApiKey);
        url.append("&bbox=" + boundingBox.getLonWest());
        url.append("," + boundingBox.getLatSouth());
        url.append("," + boundingBox.getLonEast());
        url.append("," + boundingBox.getLatNorth());
        url.append("&has_geo=1");
        url.append("&format=json&nojsoncallback=1");
        url.append("&per_page=" + maxResults);
        url.append("&min_upload_date=2005/01/01");
        url.append("&extras=geo,url_sq");
        url.append("&sort=interestingness-desc");
        return url.toString();
    }

    public ArrayList<POI> getThem(String fullUrl) {
        Log.d((String)"BONUSPACK", (String)("FlickrPOIProvider:get:" + fullUrl));
        String jString = BonusPackHelper.requestStringFromUrl(fullUrl);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"FlickrPOIProvider: request failed.");
            return null;
        }
        try {
            JSONObject jRoot = new JSONObject(jString);
            JSONObject jPhotos = jRoot.getJSONObject("photos");
            JSONArray jPhotoArray = jPhotos.getJSONArray("photo");
            int n = jPhotoArray.length();
            ArrayList<POI> pois = new ArrayList<POI>(n);
            for (int i = 0; i < n; ++i) {
                JSONObject jPhoto = jPhotoArray.getJSONObject(i);
                String photoId = jPhoto.getString("id");
                POI poi = new POI(POI.POI_SERVICE_FLICKR);
                poi.mLocation = new GeoPoint(jPhoto.getDouble("latitude"), jPhoto.getDouble("longitude"));
                poi.mId = Long.parseLong(photoId);
                poi.mType = jPhoto.getString("title");
                poi.mThumbnailPath = jPhoto.getString("url_sq");
                String owner = jPhoto.getString("owner");
                poi.mUrl = "https://www.flickr.com/photos/" + owner + "/" + photoId;
                pois.add(poi);
            }
            int total = jPhotos.getInt("total");
            Log.d((String)"BONUSPACK", (String)("done:" + n + " got, on a total of:" + total));
            return pois;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<POI> getPOIInside(BoundingBox boundingBox, int maxResults) {
        String url = this.getUrlInside(boundingBox, maxResults);
        return this.getThem(url);
    }
}

