/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.Polyline;
import org.osmdroid.views.overlay.infowindow.BasicInfoWindow;
import org.osmdroid.views.overlay.infowindow.InfoWindow;

public class KmlTrack
extends KmlGeometry {
    static int mDefaultLayoutResId = 0;
    public ArrayList<Date> mWhen;
    static final SimpleDateFormat KML_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    public static final Parcelable.Creator<KmlTrack> CREATOR = new Parcelable.Creator<KmlTrack>(){

        public KmlTrack createFromParcel(Parcel source) {
            return new KmlTrack(source);
        }

        public KmlTrack[] newArray(int size) {
            return new KmlTrack[size];
        }
    };

    public KmlTrack() {
        this.mCoordinates = new ArrayList();
        this.mWhen = new ArrayList();
    }

    public static GeoPoint parseKmlGxCoord(String sGxCoord) {
        int end1 = sGxCoord.indexOf(32);
        int end2 = sGxCoord.indexOf(32, end1 + 1);
        try {
            double lon = Double.parseDouble(sGxCoord.substring(0, end1));
            double lat = Double.parseDouble(sGxCoord.substring(end1 + 1, end2));
            double alt = Double.parseDouble(sGxCoord.substring(end2 + 1, sGxCoord.length()));
            return new GeoPoint(lat, lon, alt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public void addGxCoord(String sGxCoord) {
        this.mCoordinates.add(KmlTrack.parseKmlGxCoord(sGxCoord));
    }

    public static Date parseKmlWhen(String sWhen) {
        SimpleDateFormat ft;
        switch (sWhen.length()) {
            case 4: {
                ft = new SimpleDateFormat("yyyy");
                break;
            }
            case 7: {
                ft = new SimpleDateFormat("yyyy-MM");
                break;
            }
            case 10: {
                ft = new SimpleDateFormat("yyyy-MM-dd");
                break;
            }
            case 19: {
                ft = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                break;
            }
            case 20: {
                ft = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                break;
            }
            default: {
                return null;
            }
        }
        try {
            Date when = ft.parse(sWhen);
            return when;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void addWhen(String sWhen) {
        if (this.mWhen == null) {
            this.mWhen = new ArrayList();
        }
        this.mWhen.add(KmlTrack.parseKmlWhen(sWhen));
    }

    public void add(GeoPoint coord, Date when) {
        if (coord == null) {
            this.mCoordinates.add(coord);
        } else {
            this.mCoordinates.add(coord.clone());
        }
        this.mWhen.add(when);
    }

    public void applyDefaultStyling(Polyline lineStringOverlay, Style defaultStyle, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument, MapView map) {
        Context context = map.getContext();
        Style style = kmlDocument.getStyle(kmlPlacemark.mStyle);
        if (style != null) {
            lineStringOverlay.setColor(style.getOutlinePaint().getColor());
            lineStringOverlay.setWidth(style.getOutlinePaint().getStrokeWidth());
        } else if (defaultStyle != null && defaultStyle.mLineStyle != null) {
            lineStringOverlay.setColor(defaultStyle.getOutlinePaint().getColor());
            lineStringOverlay.setWidth(defaultStyle.getOutlinePaint().getStrokeWidth());
        }
        if (kmlPlacemark.mName != null && !"".equals(kmlPlacemark.mName) || kmlPlacemark.mDescription != null && !"".equals(kmlPlacemark.mDescription) || lineStringOverlay.getSubDescription() != null && !"".equals(lineStringOverlay.getSubDescription())) {
            if (mDefaultLayoutResId == 0) {
                String packageName = context.getPackageName();
                mDefaultLayoutResId = context.getResources().getIdentifier("layout/bonuspack_bubble", null, packageName);
            }
            lineStringOverlay.setInfoWindow((InfoWindow)new BasicInfoWindow(mDefaultLayoutResId, map));
        }
        lineStringOverlay.setEnabled(kmlPlacemark.mVisibility);
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument) {
        Polyline lineStringOverlay = new Polyline();
        lineStringOverlay.setGeodesic(true);
        lineStringOverlay.setPoints((List)this.mCoordinates);
        lineStringOverlay.setTitle(kmlPlacemark.mName);
        lineStringOverlay.setSnippet(kmlPlacemark.mDescription);
        lineStringOverlay.setSubDescription(kmlPlacemark.getExtendedDataAsText());
        lineStringOverlay.setRelatedObject((Object)this);
        lineStringOverlay.setId(this.mId);
        if (styler != null) {
            styler.onTrack(lineStringOverlay, kmlPlacemark, this);
        } else {
            this.applyDefaultStyling(lineStringOverlay, defaultStyle, kmlPlacemark, kmlDocument, map);
        }
        return lineStringOverlay;
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<gx:Track>\n");
            for (Date when : this.mWhen) {
                writer.write("<when>");
                if (when != null) {
                    writer.write(KML_DATE_FORMAT.format(when));
                }
                writer.write("</when>\n");
            }
            for (GeoPoint coord : this.mCoordinates) {
                writer.write("<gx:coord>");
                if (coord != null) {
                    writer.write(coord.getLongitude() + " " + coord.getLatitude() + " " + coord.getAltitude());
                }
                writer.write("</gx:coord>\n");
            }
            writer.write("</gx:Track>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonObject asGeoJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "LineString");
        json.add("coordinates", (JsonElement)KmlGeometry.geoJSONCoordinates(this.mCoordinates));
        return json;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return BoundingBox.fromGeoPoints((List)this.mCoordinates);
    }

    @Override
    public KmlTrack clone() {
        KmlTrack cloned = (KmlTrack)super.clone();
        cloned.mWhen = new ArrayList(this.mWhen.size());
        for (Date d : this.mWhen) {
            cloned.mWhen.add((Date)d.clone());
        }
        return cloned;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeList(this.mWhen);
    }

    public KmlTrack(Parcel in) {
        super(in);
        this.mWhen = in.readArrayList(Date.class.getClassLoader());
    }
}

