/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.FolderOverlay;
import org.osmdroid.views.overlay.Overlay;

public class KmlMultiGeometry
extends KmlGeometry
implements Cloneable,
Parcelable {
    public ArrayList<KmlGeometry> mItems;
    public static final Parcelable.Creator<KmlMultiGeometry> CREATOR = new Parcelable.Creator<KmlMultiGeometry>(){

        public KmlMultiGeometry createFromParcel(Parcel source) {
            return new KmlMultiGeometry(source);
        }

        public KmlMultiGeometry[] newArray(int size) {
            return new KmlMultiGeometry[size];
        }
    };

    public KmlMultiGeometry() {
        this.mItems = new ArrayList();
    }

    public KmlMultiGeometry(JsonObject json) {
        block10: {
            String type;
            block9: {
                this();
                type = json.get("type").getAsString();
                if (!"GeometryCollection".equals(type)) break block9;
                JsonArray geometries = json.get("geometries").getAsJsonArray();
                if (geometries == null) break block10;
                for (JsonElement geometrieJSON : geometries) {
                    this.mItems.add(KmlMultiGeometry.parseGeoJSON(geometrieJSON.getAsJsonObject()));
                }
                break block10;
            }
            if ("MultiPoint".equals(type)) {
                JsonArray coordinates = json.get("coordinates").getAsJsonArray();
                ArrayList<GeoPoint> positions = KmlMultiGeometry.parseGeoJSONPositions(coordinates);
                for (GeoPoint p : positions) {
                    KmlPoint kmlPoint = new KmlPoint(p);
                    this.mItems.add(kmlPoint);
                }
            } else if ("MultiLineString".equals(type)) {
                JsonArray lineStrings = json.get("coordinates").getAsJsonArray();
                for (JsonElement lineStringE : lineStrings) {
                    JsonArray lineStringA = (JsonArray)lineStringE;
                    KmlLineString lineString = new KmlLineString(lineStringA);
                    this.mItems.add(lineString);
                }
            } else if ("MultiPolygon".equals(type)) {
                JsonArray polygonsA = json.get("coordinates").getAsJsonArray();
                for (JsonElement polygonE : polygonsA) {
                    JsonArray polygonA = (JsonArray)polygonE;
                    KmlPolygon polygon = new KmlPolygon(polygonA);
                    this.mItems.add(polygon);
                }
            }
        }
    }

    public void addItem(KmlGeometry item) {
        this.mItems.add(item);
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument) {
        FolderOverlay folderOverlay = new FolderOverlay();
        for (KmlGeometry k : this.mItems) {
            Overlay overlay = k.buildOverlay(map, defaultStyle, styler, kmlPlacemark, kmlDocument);
            folderOverlay.add(overlay);
        }
        return folderOverlay;
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<MultiGeometry>\n");
            for (KmlGeometry item : this.mItems) {
                item.saveAsKML(writer);
            }
            writer.write("</MultiGeometry>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonObject asGeoJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "GeometryCollection");
        JsonArray geometries = new JsonArray();
        for (KmlGeometry item : this.mItems) {
            geometries.add((JsonElement)item.asGeoJSON());
        }
        json.add("geometries", (JsonElement)geometries);
        return json;
    }

    @Override
    public BoundingBox getBoundingBox() {
        BoundingBox finalBB = null;
        for (KmlGeometry item : this.mItems) {
            BoundingBox itemBB = item.getBoundingBox();
            if (itemBB == null) continue;
            if (finalBB == null) {
                finalBB = itemBB.clone();
                continue;
            }
            finalBB = finalBB.concat(itemBB);
        }
        return finalBB;
    }

    @Override
    public KmlMultiGeometry clone() {
        KmlMultiGeometry kmlMultiGeometry = (KmlMultiGeometry)super.clone();
        kmlMultiGeometry.mItems = new ArrayList(this.mItems.size());
        for (KmlGeometry item : this.mItems) {
            kmlMultiGeometry.mItems.add(item.clone());
        }
        return kmlMultiGeometry;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeList(this.mItems);
    }

    public KmlMultiGeometry(Parcel in) {
        super(in);
        this.mItems = in.readArrayList(KmlGeometry.class.getClassLoader());
    }
}

