/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.bonuspack.clustering.MarkerClusterer;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGroundOverlay;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.bonuspack.overlays.GroundOverlay;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.FolderOverlay;
import org.osmdroid.views.overlay.Marker;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.Polygon;
import org.osmdroid.views.overlay.Polyline;

public class KmlFolder
extends KmlFeature
implements Cloneable,
Parcelable {
    public ArrayList<KmlFeature> mItems;
    public static final Parcelable.Creator<KmlFolder> CREATOR = new Parcelable.Creator<KmlFolder>(){

        public KmlFolder createFromParcel(Parcel source) {
            return new KmlFolder(source);
        }

        public KmlFolder[] newArray(int size) {
            return new KmlFolder[size];
        }
    };

    public KmlFolder() {
        this.mItems = new ArrayList();
    }

    public KmlFolder(FolderOverlay overlay, KmlDocument kmlDoc) {
        this();
        this.addOverlays(overlay.getItems(), kmlDoc);
        this.mName = overlay.getName();
        this.mDescription = overlay.getDescription();
        this.mVisibility = overlay.isEnabled();
    }

    public KmlFolder(MarkerClusterer overlay, KmlDocument kmlDoc) {
        this();
        this.addOverlays(overlay.getItems(), kmlDoc);
        this.mName = overlay.getName();
        this.mDescription = overlay.getDescription();
        this.mVisibility = overlay.isEnabled();
    }

    public KmlFolder(JsonObject json) {
        this();
        if (json.has("features")) {
            JsonArray features = json.get("features").getAsJsonArray();
            for (JsonElement jsonFeature : features) {
                KmlFeature feature = KmlFeature.parseGeoJSON(jsonFeature.getAsJsonObject());
                this.add(feature);
            }
        }
    }

    @Override
    public BoundingBox getBoundingBox() {
        BoundingBox BB = null;
        for (KmlFeature item : this.mItems) {
            BoundingBox itemBB = item.getBoundingBox();
            if (itemBB == null) continue;
            if (BB == null) {
                BB = itemBB.clone();
                continue;
            }
            BB = BB.concat(itemBB);
        }
        return BB;
    }

    public boolean addOverlay(Overlay overlay, KmlDocument kmlDoc) {
        KmlFeature kmlItem;
        if (overlay == null) {
            return false;
        }
        if (overlay instanceof GroundOverlay) {
            kmlItem = new KmlGroundOverlay((GroundOverlay)overlay);
        } else if (overlay instanceof FolderOverlay) {
            kmlItem = new KmlFolder((FolderOverlay)overlay, kmlDoc);
        } else if (overlay instanceof MarkerClusterer) {
            kmlItem = new KmlFolder((MarkerClusterer)overlay, kmlDoc);
        } else if (overlay instanceof Marker) {
            Marker marker = (Marker)overlay;
            kmlItem = new KmlPlacemark(marker);
        } else if (overlay instanceof Polygon) {
            Polygon polygon = (Polygon)overlay;
            kmlItem = new KmlPlacemark(polygon, kmlDoc);
        } else if (overlay instanceof Polyline) {
            Polyline polyline = (Polyline)overlay;
            kmlItem = new KmlPlacemark(polyline, kmlDoc);
        } else {
            return false;
        }
        this.mItems.add(kmlItem);
        return true;
    }

    public void addOverlays(List<? extends Overlay> overlays, KmlDocument kmlDoc) {
        if (overlays != null) {
            for (Overlay overlay : overlays) {
                this.addOverlay(overlay, kmlDoc);
            }
        }
    }

    public void add(KmlFeature item) {
        this.mItems.add(item);
    }

    public KmlFeature removeItem(int itemPosition) {
        return this.mItems.remove(itemPosition);
    }

    public KmlFeature findFeatureId(String id, boolean recurse) {
        for (KmlFeature f : this.mItems) {
            KmlFeature ff;
            if (f.mId != null && f.mId.equals(id)) {
                return f;
            }
            if (!recurse || !(f instanceof KmlFolder) || (ff = this.findFeatureId(id, recurse)) == null) continue;
            return ff;
        }
        return null;
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlDocument kmlDocument) {
        FolderOverlay folderOverlay = new FolderOverlay();
        folderOverlay.setName(this.mName);
        folderOverlay.setDescription(this.mDescription);
        for (KmlFeature k : this.mItems) {
            Overlay overlay = k.buildOverlay(map, defaultStyle, styler, kmlDocument);
            if (overlay == null) continue;
            folderOverlay.add(overlay);
        }
        if (styler == null) {
            folderOverlay.setEnabled(this.mVisibility);
        } else {
            styler.onFeature((Overlay)folderOverlay, this);
        }
        return folderOverlay;
    }

    @Override
    public void writeKMLSpecifics(Writer writer) {
        try {
            if (!this.mOpen) {
                writer.write("<open>0</open>\n");
            }
            for (KmlFeature item : this.mItems) {
                item.writeAsKML(writer, false, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsonObject geoJSONNamedCRS(String crsName) {
        JsonObject crs = new JsonObject();
        crs.addProperty("type", "name");
        JsonObject properties = new JsonObject();
        properties.addProperty("name", crsName);
        crs.add("properties", (JsonElement)properties);
        return crs;
    }

    @Override
    public JsonObject asGeoJSON(boolean isRoot) {
        JsonObject json = new JsonObject();
        if (isRoot) {
            json.add("crs", (JsonElement)this.geoJSONNamedCRS("urn:ogc:def:crs:OGC:1.3:CRS84"));
        }
        JsonArray features = new JsonArray();
        for (KmlFeature item : this.mItems) {
            JsonObject subJson = item.asGeoJSON(false);
            if (item instanceof KmlFolder) {
                JsonArray subFeatures = subJson.getAsJsonArray("features");
                if (subFeatures == null) continue;
                for (int i = 0; i < subFeatures.size(); ++i) {
                    JsonElement j = subFeatures.get(i);
                    features.add(j);
                }
                continue;
            }
            if (subJson == null) continue;
            features.add((JsonElement)subJson);
        }
        json.add("features", (JsonElement)features);
        json.addProperty("type", "FeatureCollection");
        return json;
    }

    @Override
    public KmlFolder clone() {
        KmlFolder kmlFolder = (KmlFolder)super.clone();
        if (this.mItems != null) {
            kmlFolder.mItems = new ArrayList(this.mItems.size());
            for (KmlFeature item : this.mItems) {
                kmlFolder.mItems.add(item.clone());
            }
        }
        return kmlFolder;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeList(this.mItems);
    }

    public KmlFolder(Parcel in) {
        super(in);
        this.mItems = in.readArrayList(KmlFeature.class.getClassLoader());
    }
}

