/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.logs;

import com.thebuzzmedia.exiftool.commons.reflection.DependencyUtils;
import com.thebuzzmedia.exiftool.logs.DefaultLogger;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerLog4j;
import com.thebuzzmedia.exiftool.logs.LoggerLog4j2;
import com.thebuzzmedia.exiftool.logs.LoggerProvider;
import com.thebuzzmedia.exiftool.logs.LoggerSlf4j;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class LoggerFactory {
    private static final LoggerProvider loggerProvider;

    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> klass) {
        if (loggerProvider != null) {
            return loggerProvider.getLogger(klass);
        }
        if (DependencyUtils.isSlf4jAvailable()) {
            return new LoggerSlf4j(klass);
        }
        if (DependencyUtils.isLog4j2Available()) {
            return new LoggerLog4j2(klass);
        }
        if (DependencyUtils.isLog4jAvailable()) {
            return new LoggerLog4j(klass);
        }
        return new DefaultLogger(Boolean.getBoolean("exiftool.debug"));
    }

    static {
        ServiceLoader<LoggerProvider> loggerProviders = ServiceLoader.load(LoggerProvider.class);
        Iterator<LoggerProvider> it = loggerProviders.iterator();
        loggerProvider = it.hasNext() ? it.next() : null;
    }
}

