/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.schedulers;

import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.commons.lang.ToStringBuilder;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class SchedulerDuration {
    private final long delay;
    private final TimeUnit timeUnit;

    public static SchedulerDuration seconds(long delay) {
        return new SchedulerDuration(delay, TimeUnit.SECONDS);
    }

    public static SchedulerDuration millis(long delay) {
        return new SchedulerDuration(delay, TimeUnit.MILLISECONDS);
    }

    public static SchedulerDuration duration(long delay, TimeUnit timeUnit) {
        return new SchedulerDuration(delay, timeUnit);
    }

    private SchedulerDuration(long delay, TimeUnit timeUnit) {
        this.delay = PreConditions.isPositive(delay, "Delay should be a strictly positive value");
        this.timeUnit = Objects.requireNonNull(timeUnit, "Time Unit should not be null");
    }

    public long getDelay() {
        return this.delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("delay", this.delay).append("timeUnit", (Object)this.timeUnit).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SchedulerDuration) {
            SchedulerDuration d = (SchedulerDuration)o;
            return Objects.equals(this.delay, d.delay) && Objects.equals((Object)this.timeUnit, (Object)d.timeUnit);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.delay, this.timeUnit});
    }
}

