/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.schedulers;

import com.thebuzzmedia.exiftool.Scheduler;
import com.thebuzzmedia.exiftool.core.schedulers.SchedulerDuration;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import java.util.Objects;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultScheduler
implements Scheduler {
    private static final Logger log = LoggerFactory.getLogger(DefaultScheduler.class);
    private final SchedulerDuration executionDelay;
    private final SchedulerDuration terminationDelay;
    private final ScheduledThreadPoolExecutor executor;

    @Deprecated
    public DefaultScheduler(long delay) {
        this(SchedulerDuration.millis(delay));
    }

    @Deprecated
    public DefaultScheduler(long delay, TimeUnit timeUnit) {
        this(SchedulerDuration.duration(delay, timeUnit));
    }

    public DefaultScheduler(SchedulerDuration executionDelay) {
        this(executionDelay, SchedulerDuration.seconds(5L));
    }

    public DefaultScheduler(SchedulerDuration executionDelay, SchedulerDuration terminationDelay) {
        this.executionDelay = Objects.requireNonNull(executionDelay, "Execution delay must not be null");
        this.terminationDelay = Objects.requireNonNull(terminationDelay, "Termination delay must not be null");
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.setRemoveOnCancelPolicy(true);
    }

    @Override
    public synchronized void start(Runnable runnable) {
        this.executor.schedule(runnable, this.executionDelay.getDelay(), this.executionDelay.getTimeUnit());
    }

    @Override
    public synchronized void stop() {
        for (Runnable runnable : this.executor.getQueue()) {
            ((RunnableFuture)runnable).cancel(false);
        }
        this.executor.purge();
    }

    @Override
    public synchronized void shutdown() {
        this.stop();
        this.processShutdown();
    }

    private void processShutdown() {
        log.debug("Shutdown scheduler");
        this.executor.shutdown();
        try {
            log.debug("Wait for scheduler termination");
            if (!this.executor.awaitTermination(this.terminationDelay.getDelay(), this.terminationDelay.getTimeUnit())) {
                log.debug("Termination seems to failed, shutdown now");
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(this.terminationDelay.getDelay(), this.terminationDelay.getTimeUnit())) {
                    log.error("Scheduler did not seem to terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

