/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Class<?> lookupClass(String klass) {
        try {
            return Class.forName(klass);
        }
        catch (ClassNotFoundException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static MethodHandle findStaticMethod(Class<?> klass, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType mt = MethodType.methodType(returnType, parameterTypes);
        try {
            return lookup.findStatic(klass, methodName, mt);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static MethodHandle findMethod(Class<?> klass, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType mt = MethodType.methodType(returnType, parameterTypes);
        try {
            return lookup.findVirtual(klass, methodName, mt);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            throw new ReflectionException(ex);
        }
    }

    public static Object invokeStatic(MethodHandle method, Object ... args) {
        return ClassUtils.doInvoke(method, args);
    }

    public static Object invoke(MethodHandle method, Object target, Object ... args) {
        return ClassUtils.doInvoke(method.bindTo(target), args);
    }

    private static Object doInvoke(MethodHandle method, Object ... args) {
        try {
            return method.invokeWithArguments(args);
        }
        catch (Throwable ex) {
            throw new ReflectionException(ex);
        }
    }

    public static boolean isPresent(String klass) {
        try {
            Class.forName(klass);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static class ReflectionException
    extends RuntimeException {
        private ReflectionException(Throwable cause) {
            super(cause);
        }
    }
}

