/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool;

import com.thebuzzmedia.exiftool.ExecutionStrategy;
import com.thebuzzmedia.exiftool.ExifTool;
import com.thebuzzmedia.exiftool.Scheduler;
import com.thebuzzmedia.exiftool.core.schedulers.DefaultScheduler;
import com.thebuzzmedia.exiftool.core.schedulers.NoOpScheduler;
import com.thebuzzmedia.exiftool.core.schedulers.SchedulerDuration;
import com.thebuzzmedia.exiftool.core.strategies.DefaultStrategy;
import com.thebuzzmedia.exiftool.core.strategies.PoolStrategy;
import com.thebuzzmedia.exiftool.core.strategies.StayOpenStrategy;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import com.thebuzzmedia.exiftool.process.executor.CommandExecutors;
import java.io.File;
import java.util.ArrayList;

public class ExifToolBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExifToolBuilder.class);
    private static final PathFunction PATH = new PathFunction();
    private static final DelayFunction DELAY = new DelayFunction();
    private static final ExecutorFunction EXECUTOR = new ExecutorFunction();
    private String path;
    private CommandExecutor executor;
    private Boolean stayOpen;
    private Long cleanupDelay;
    private ExecutionStrategy strategy;
    private Scheduler scheduler;
    private int poolSize;

    public ExifToolBuilder withPath(String path) {
        log.debug("Set path: {}", path);
        this.path = path;
        return this;
    }

    public ExifToolBuilder withPath(File path) {
        log.debug("Set path: {}", path);
        if (!path.canExecute()) {
            log.warn("Executable {} is not executable, exiftool may fail later", path);
        }
        this.path = path.getAbsolutePath();
        return this;
    }

    public ExifToolBuilder withExecutor(CommandExecutor executor) {
        log.debug("Set withExecutor: {}", executor);
        this.executor = executor;
        return this;
    }

    public ExifToolBuilder enableStayOpen() {
        log.debug("Enable 'stay_open' feature");
        if (this.strategy != null) {
            log.warn("A custom strategy is defined, enabling 'stay_open' feature will be ignored");
        }
        this.stayOpen = true;
        return this;
    }

    public ExifToolBuilder enableStayOpen(long cleanupDelay) {
        log.debug("Enable 'stay_open' feature");
        if (this.strategy != null) {
            log.warn("A custom strategy is defined, enabling 'stay_open' feature will be ignored");
        }
        if (this.scheduler != null) {
            log.warn("A custom scheduler is already defined, it will be ignored");
        }
        this.stayOpen = true;
        this.cleanupDelay = cleanupDelay;
        return this;
    }

    public ExifToolBuilder enableStayOpen(Scheduler scheduler) {
        log.debug("Enable 'stay_open' feature");
        if (this.strategy != null) {
            log.warn("A custom strategy is defined, enabling 'stay_open' feature will be ignored");
        }
        if (this.cleanupDelay != null) {
            log.warn("Custom scheduler is defined, previous delay will be ignored");
        }
        this.stayOpen = true;
        this.scheduler = scheduler;
        return this;
    }

    public ExifToolBuilder withStrategy(ExecutionStrategy strategy) {
        log.debug("Overriding default strategy");
        if (this.stayOpen != null) {
            log.warn("Flag 'stay_open' has been enabled and you are overriding the default execution strategy.");
            log.warn("Enabling 'stay_open' feature will be ignored");
        }
        this.strategy = strategy;
        return this;
    }

    public ExifToolBuilder withPoolSize(int poolSize, long cleanupDelay) {
        log.debug("Overriding default strategy");
        if (poolSize > 0) {
            this.poolSize = poolSize;
            this.cleanupDelay = cleanupDelay;
        } else {
            log.warn("Pool size has been enabled with a value less or equal than zero, ignore it.");
        }
        return this;
    }

    public ExifToolBuilder withPoolSize(int poolSize) {
        log.debug("Overriding default strategy");
        if (poolSize > 0) {
            this.poolSize = poolSize;
            this.cleanupDelay = 0L;
        } else {
            log.warn("Pool size has been enabled with a value less or equal than zero, ignore it.");
        }
        return this;
    }

    public ExifTool build() {
        String path = ExifToolBuilder.firstNonNull(this.path, PATH);
        CommandExecutor executor = ExifToolBuilder.firstNonNull(this.executor, EXECUTOR);
        ExecutionStrategy strategy = ExifToolBuilder.firstNonNull(this.strategy, new StrategyFunction(this.stayOpen, this.cleanupDelay, this.scheduler, this.poolSize));
        if (log.isDebugEnabled()) {
            log.debug("Create ExifTool instance:");
            log.debug(" - Path: {}", path);
            log.debug(" - Executor: {}", executor);
            log.debug(" - Strategy: {}", strategy);
            log.debug(" - StayOpen: {}", this.stayOpen);
        }
        return new ExifTool(path, executor, strategy);
    }

    private static <T> T firstNonNull(T value, FactoryFunction<T> factory) {
        return value == null ? factory.apply() : value;
    }

    private static interface FactoryFunction<T> {
        public T apply();
    }

    private static class DelayFunction
    implements FactoryFunction<Long> {
        private DelayFunction() {
        }

        @Override
        public Long apply() {
            return Long.getLong("exiftool.processCleanupDelay", 600000L);
        }
    }

    private static class PathFunction
    implements FactoryFunction<String> {
        private PathFunction() {
        }

        @Override
        public String apply() {
            return System.getProperty("exiftool.path", "exiftool");
        }
    }

    private static class ExecutorFunction
    implements FactoryFunction<CommandExecutor> {
        private ExecutorFunction() {
        }

        @Override
        public CommandExecutor apply() {
            return CommandExecutors.newExecutor();
        }
    }

    private static class StrategyFunction
    implements FactoryFunction<ExecutionStrategy> {
        private final Boolean stayOpen;
        private final Long delay;
        private final Scheduler scheduler;
        private final int poolSize;

        public StrategyFunction(Boolean stayOpen, Long delay, Scheduler scheduler, int poolSize) {
            this.stayOpen = stayOpen;
            this.delay = delay;
            this.scheduler = scheduler;
            this.poolSize = poolSize;
        }

        @Override
        public ExecutionStrategy apply() {
            if (this.poolSize > 0) {
                ArrayList<ExecutionStrategy> strategies = new ArrayList<ExecutionStrategy>(this.poolSize);
                for (int i = 0; i < this.poolSize; ++i) {
                    Scheduler scheduler = new SchedulerFunction(this.delay).apply();
                    StayOpenStrategy strategy = new StayOpenStrategy(scheduler);
                    strategies.add(strategy);
                }
                return new PoolStrategy(strategies);
            }
            if (this.stayOpen != null && this.stayOpen.booleanValue()) {
                return new StayOpenStrategy((Scheduler)ExifToolBuilder.firstNonNull(this.scheduler, new SchedulerFunction(this.delay)));
            }
            return new DefaultStrategy();
        }
    }

    private static class SchedulerFunction
    implements FactoryFunction<Scheduler> {
        private final Long delay;

        public SchedulerFunction(Long delay) {
            this.delay = delay;
        }

        @Override
        public Scheduler apply() {
            long delay = (Long)ExifToolBuilder.firstNonNull(this.delay, DELAY);
            return delay > 0L ? new DefaultScheduler(SchedulerDuration.millis(delay)) : new NoOpScheduler();
        }
    }
}

