/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.partition;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.driver.ByteBlockDevice;
import com.github.mjdev.libaums.fs.FileSystem;
import com.github.mjdev.libaums.fs.FileSystemFactory;
import com.github.mjdev.libaums.partition.PartitionTableEntry;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/github/mjdev/libaums/partition/Partition;", "Lcom/github/mjdev/libaums/driver/ByteBlockDevice;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "entry", "Lcom/github/mjdev/libaums/partition/PartitionTableEntry;", "(Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;Lcom/github/mjdev/libaums/partition/PartitionTableEntry;)V", "<set-?>", "Lcom/github/mjdev/libaums/fs/FileSystem;", "fileSystem", "getFileSystem", "()Lcom/github/mjdev/libaums/fs/FileSystem;", "volumeLabel", "", "getVolumeLabel", "()Ljava/lang/String;", "Companion", "libaums_release"})
public final class Partition
extends ByteBlockDevice {
    @NotNull
    private FileSystem fileSystem;
    private static final String TAG;
    public static final Companion Companion;

    @NotNull
    public final FileSystem getFileSystem() {
        FileSystem fileSystem = this.fileSystem;
        if (fileSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileSystem");
        }
        return fileSystem;
    }

    @NotNull
    public final String getVolumeLabel() {
        FileSystem fileSystem = this.fileSystem;
        if (fileSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileSystem");
        }
        return fileSystem.getVolumeLabel();
    }

    public Partition(@NotNull BlockDeviceDriver blockDevice, @NotNull PartitionTableEntry entry) {
        Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
        Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
        super(blockDevice, entry.getLogicalBlockAddress());
    }

    static {
        Companion = new Companion(null);
        String string = Partition.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Partition::class.java.simpleName");
        TAG = string;
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(Partition $this) {
        FileSystem fileSystem = $this.fileSystem;
        if (fileSystem == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileSystem");
        }
        return fileSystem;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/github/mjdev/libaums/partition/Partition$Companion;", "", "()V", "TAG", "", "createPartition", "Lcom/github/mjdev/libaums/partition/Partition;", "entry", "Lcom/github/mjdev/libaums/partition/PartitionTableEntry;", "blockDevice", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "libaums_release"})
    public static final class Companion {
        @Nullable
        public final Partition createPartition(@NotNull PartitionTableEntry entry, @NotNull BlockDeviceDriver blockDevice) throws IOException {
            Partition partition;
            Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
            Intrinsics.checkParameterIsNotNull((Object)blockDevice, (String)"blockDevice");
            try {
                Partition partition2 = new Partition(blockDevice, entry);
                FileSystem fs = FileSystemFactory.INSTANCE.createFileSystem(entry, partition2);
                partition2.fileSystem = fs;
            }
            catch (FileSystemFactory.UnsupportedFileSystemException e) {
                Log.w((String)TAG, (String)"Unsupported fs on partition");
                partition = null;
            }
            return partition;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

