/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import android.util.Log;
import com.github.mjdev.libaums.fs.UsbFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/mjdev/libaums/fs/UsbFileInputStream;", "Ljava/io/InputStream;", "file", "Lcom/github/mjdev/libaums/fs/UsbFile;", "(Lcom/github/mjdev/libaums/fs/UsbFile;)V", "currentByteOffset", "", "available", "", "close", "", "read", "buffer", "", "byteOffset", "byteCount", "skip", "Companion", "libaums_release"})
public final class UsbFileInputStream
extends InputStream {
    private long currentByteOffset;
    private final UsbFile file;
    private static final String TAG;
    public static final Companion Companion;

    @Override
    public int available() throws IOException {
        Log.d((String)TAG, (String)"available");
        return 0;
    }

    @Override
    public int read() throws IOException {
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.allocate(512);
        buffer.limit(1);
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        this.file.read(this.currentByteOffset, byteBuffer);
        long l = this.currentByteOffset;
        this.currentByteOffset = l + 1L;
        buffer.flip();
        return buffer.get();
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public int read(@NotNull byte[] buffer) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long length = this.file.getLength();
        long toRead = Math.min((long)buffer.length, length - this.currentByteOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.limit((int)toRead);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"byteBuffer");
        this.file.read(this.currentByteOffset, byteBuffer2);
        this.currentByteOffset += toRead;
        return (int)toRead;
    }

    @Override
    public int read(@NotNull byte[] buffer, int byteOffset, int byteCount) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        if (this.currentByteOffset >= this.file.getLength()) {
            return -1;
        }
        long length = this.file.getLength();
        long toRead = Math.min((long)byteCount, length - this.currentByteOffset);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.position(byteOffset);
        byteBuffer.limit((int)toRead + byteOffset);
        ByteBuffer byteBuffer2 = byteBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"byteBuffer");
        this.file.read(this.currentByteOffset, byteBuffer2);
        this.currentByteOffset += toRead;
        return (int)toRead;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        long skippedBytes = Math.min(byteCount, this.file.getLength() - this.currentByteOffset);
        this.currentByteOffset += skippedBytes;
        return skippedBytes;
    }

    public UsbFileInputStream(@NotNull UsbFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        if (this.file.isDirectory()) {
            throw (Throwable)new UnsupportedOperationException("UsbFileInputStream cannot be created on directory!");
        }
    }

    static {
        Companion = new Companion(null);
        String string = UsbFileInputStream.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UsbFileInputStream::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/mjdev/libaums/fs/UsbFileInputStream$Companion;", "", "()V", "TAG", "", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

