/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbRequest;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/mjdev/libaums/usb/UsbRequestCommunication;", "Lcom/github/mjdev/libaums/usb/UsbCommunication;", "deviceConnection", "Landroid/hardware/usb/UsbDeviceConnection;", "outEndpoint", "Landroid/hardware/usb/UsbEndpoint;", "inEndpoint", "(Landroid/hardware/usb/UsbDeviceConnection;Landroid/hardware/usb/UsbEndpoint;Landroid/hardware/usb/UsbEndpoint;)V", "inRequest", "Landroid/hardware/usb/UsbRequest;", "outRequest", "workaroundBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "bulkInTransfer", "", "dest", "bulkOutTransfer", "src", "libaums_release"})
public final class UsbRequestCommunication
implements UsbCommunication {
    private final UsbRequest outRequest;
    private final UsbRequest inRequest;
    private final ByteBuffer workaroundBuffer;
    private final UsbDeviceConnection deviceConnection;

    @Override
    public synchronized int bulkOutTransfer(@NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        int length = src.remaining();
        int oldPosition = src.position();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.put(src);
        if (!this.outRequest.queue(this.workaroundBuffer, length)) {
            throw (Throwable)new IOException("Error queueing request.");
        }
        UsbRequest request = this.deviceConnection.requestWait();
        if (request == this.outRequest) {
            src.position(oldPosition + this.workaroundBuffer.position());
            return this.workaroundBuffer.position();
        }
        throw (Throwable)new IOException("requestWait failed! Request: " + request);
    }

    @Override
    public synchronized int bulkInTransfer(@NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        int length = dest.remaining();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.limit(length);
        if (!this.inRequest.queue(this.workaroundBuffer, length)) {
            throw (Throwable)new IOException("Error queueing request.");
        }
        UsbRequest request = this.deviceConnection.requestWait();
        if (request == this.inRequest) {
            this.workaroundBuffer.flip();
            dest.put(this.workaroundBuffer);
            return this.workaroundBuffer.limit();
        }
        throw (Throwable)new IOException("requestWait failed! Request: " + request);
    }

    public UsbRequestCommunication(@NotNull UsbDeviceConnection deviceConnection, @NotNull UsbEndpoint outEndpoint, @NotNull UsbEndpoint inEndpoint) {
        UsbRequest usbRequest;
        Intrinsics.checkParameterIsNotNull((Object)deviceConnection, (String)"deviceConnection");
        Intrinsics.checkParameterIsNotNull((Object)outEndpoint, (String)"outEndpoint");
        Intrinsics.checkParameterIsNotNull((Object)inEndpoint, (String)"inEndpoint");
        this.deviceConnection = deviceConnection;
        UsbRequest usbRequest2 = new UsbRequest();
        UsbRequestCommunication usbRequestCommunication = this;
        boolean bl = false;
        boolean bl2 = false;
        UsbRequest $this$apply = usbRequest2;
        boolean bl3 = false;
        $this$apply.initialize(this.deviceConnection, outEndpoint);
        usbRequestCommunication.outRequest = usbRequest = usbRequest2;
        usbRequest2 = new UsbRequest();
        usbRequestCommunication = this;
        bl = false;
        bl2 = false;
        $this$apply = usbRequest2;
        boolean bl4 = false;
        $this$apply.initialize(this.deviceConnection, inEndpoint);
        usbRequestCommunication.inRequest = usbRequest = usbRequest2;
        this.workaroundBuffer = ByteBuffer.allocate(131072);
    }
}

