/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\b\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0004J\b\u0010+\u001a\u00020%H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000bR\u001e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000bR\u001e\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u001e\u0010!\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u000fR\u001e\u0010#\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0013R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\u0007\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006-"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;", "", "()V", "bytesPerCluster", "", "getBytesPerCluster", "()I", "<set-?>", "", "bytesPerSector", "getBytesPerSector", "()S", "dataAreaOffset", "", "getDataAreaOffset", "()J", "", "fatCount", "getFatCount", "()B", "fsInfoStartSector", "getFsInfoStartSector", "", "isFatMirrored", "()Z", "reservedSectors", "getReservedSectors", "rootDirStartCluster", "getRootDirStartCluster", "sectorsPerCluster", "getSectorsPerCluster", "sectorsPerFat", "getSectorsPerFat", "totalNumberOfSectors", "getTotalNumberOfSectors", "validFat", "getValidFat", "", "volumeLabel", "getVolumeLabel", "()Ljava/lang/String;", "getFatOffset", "fatNumber", "toString", "Companion", "libaums_release"})
public final class Fat32BootSector {
    private short bytesPerSector;
    private short sectorsPerCluster;
    private short reservedSectors;
    private byte fatCount;
    private long totalNumberOfSectors;
    private long sectorsPerFat;
    private long rootDirStartCluster;
    private short fsInfoStartSector;
    private boolean isFatMirrored;
    private byte validFat;
    @Nullable
    private String volumeLabel;
    private static final int BYTES_PER_SECTOR_OFF = 11;
    private static final int SECTORS_PER_CLUSTER_OFF = 13;
    private static final int RESERVED_COUNT_OFF = 14;
    private static final int FAT_COUNT_OFF = 16;
    private static final int TOTAL_SECTORS_OFF = 32;
    private static final int SECTORS_PER_FAT_OFF = 36;
    private static final int FLAGS_OFF = 40;
    private static final int ROOT_DIR_CLUSTER_OFF = 44;
    private static final int FS_INFO_SECTOR_OFF = 48;
    private static final int VOLUME_LABEL_OFF = 48;
    public static final Companion Companion = new Companion(null);

    public final short getBytesPerSector() {
        return this.bytesPerSector;
    }

    public final short getSectorsPerCluster() {
        return this.sectorsPerCluster;
    }

    public final short getReservedSectors() {
        return this.reservedSectors;
    }

    public final byte getFatCount() {
        return this.fatCount;
    }

    public final long getTotalNumberOfSectors() {
        return this.totalNumberOfSectors;
    }

    public final long getSectorsPerFat() {
        return this.sectorsPerFat;
    }

    public final long getRootDirStartCluster() {
        return this.rootDirStartCluster;
    }

    public final short getFsInfoStartSector() {
        return this.fsInfoStartSector;
    }

    public final boolean isFatMirrored() {
        return this.isFatMirrored;
    }

    public final byte getValidFat() {
        return this.validFat;
    }

    @Nullable
    public final String getVolumeLabel() {
        return this.volumeLabel;
    }

    public final int getBytesPerCluster() {
        return this.sectorsPerCluster * this.bytesPerSector;
    }

    public final long getDataAreaOffset() {
        return this.getFatOffset(0) + (long)this.fatCount * this.sectorsPerFat * (long)this.bytesPerSector;
    }

    public final long getFatOffset(int fatNumber) {
        return (long)this.bytesPerSector * ((long)this.reservedSectors + (long)fatNumber * this.sectorsPerFat);
    }

    @NotNull
    public String toString() {
        return "Fat32BootSector{bytesPerSector=" + this.bytesPerSector + ", sectorsPerCluster=" + this.sectorsPerCluster + ", reservedSectors=" + this.reservedSectors + ", fatCount=" + this.fatCount + ", totalNumberOfSectors=" + this.totalNumberOfSectors + ", sectorsPerFat=" + this.sectorsPerFat + ", rootDirStartCluster=" + this.rootDirStartCluster + ", fsInfoStartSector=" + this.fsInfoStartSector + ", fatMirrored=" + this.isFatMirrored + ", validFat=" + this.validFat + ", volumeLabel='" + this.volumeLabel + "'" + "}";
    }

    private Fat32BootSector() {
    }

    public /* synthetic */ Fat32BootSector(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ short access$getBytesPerSector$p(Fat32BootSector $this) {
        return $this.bytesPerSector;
    }

    public static final /* synthetic */ short access$getSectorsPerCluster$p(Fat32BootSector $this) {
        return $this.sectorsPerCluster;
    }

    public static final /* synthetic */ short access$getReservedSectors$p(Fat32BootSector $this) {
        return $this.reservedSectors;
    }

    public static final /* synthetic */ byte access$getFatCount$p(Fat32BootSector $this) {
        return $this.fatCount;
    }

    public static final /* synthetic */ long access$getTotalNumberOfSectors$p(Fat32BootSector $this) {
        return $this.totalNumberOfSectors;
    }

    public static final /* synthetic */ long access$getSectorsPerFat$p(Fat32BootSector $this) {
        return $this.sectorsPerFat;
    }

    public static final /* synthetic */ long access$getRootDirStartCluster$p(Fat32BootSector $this) {
        return $this.rootDirStartCluster;
    }

    public static final /* synthetic */ short access$getFsInfoStartSector$p(Fat32BootSector $this) {
        return $this.fsInfoStartSector;
    }

    public static final /* synthetic */ boolean access$isFatMirrored$p(Fat32BootSector $this) {
        return $this.isFatMirrored;
    }

    public static final /* synthetic */ byte access$getValidFat$p(Fat32BootSector $this) {
        return $this.validFat;
    }

    public static final /* synthetic */ String access$getVolumeLabel$p(Fat32BootSector $this) {
        return $this.volumeLabel;
    }

    @JvmStatic
    @NotNull
    public static final Fat32BootSector read(@NotNull ByteBuffer buffer) {
        return Companion.read(buffer);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector$Companion;", "", "()V", "BYTES_PER_SECTOR_OFF", "", "FAT_COUNT_OFF", "FLAGS_OFF", "FS_INFO_SECTOR_OFF", "RESERVED_COUNT_OFF", "ROOT_DIR_CLUSTER_OFF", "SECTORS_PER_CLUSTER_OFF", "SECTORS_PER_FAT_OFF", "TOTAL_SECTORS_OFF", "VOLUME_LABEL_OFF", "read", "Lcom/github/mjdev/libaums/fs/fat32/Fat32BootSector;", "buffer", "Ljava/nio/ByteBuffer;", "libaums_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Fat32BootSector read(@NotNull ByteBuffer buffer) {
            void i;
            byte b;
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Fat32BootSector result = new Fat32BootSector(null);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            result.bytesPerSector = buffer.getShort(11);
            result.sectorsPerCluster = (short)(buffer.get(13) & 0xFF);
            result.reservedSectors = buffer.getShort(14);
            result.fatCount = buffer.get(16);
            result.totalNumberOfSectors = (long)buffer.getInt(32) & 0xFFFFFFFFL;
            result.sectorsPerFat = (long)buffer.getInt(36) & 0xFFFFFFFFL;
            result.rootDirStartCluster = (long)buffer.getInt(44) & 0xFFFFFFFFL;
            result.fsInfoStartSector = buffer.getShort(48);
            short flag = buffer.getShort(40);
            result.isFatMirrored = (flag & 0x80) == 0;
            result.validFat = (byte)(flag & 7);
            StringBuilder builder = new StringBuilder();
            int n = 0;
            int n2 = 10;
            while (n <= n2 && (b = buffer.get(48 + i)) != 0) {
                builder.append((char)b);
                ++i;
            }
            result.volumeLabel = builder.toString();
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

