/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver;

import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/mjdev/libaums/driver/ByteBlockDevice;", "Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;", "targetBlockDevice", "logicalOffsetToAdd", "", "(Lcom/github/mjdev/libaums/driver/BlockDeviceDriver;I)V", "blockSize", "getBlockSize", "()I", "init", "", "read", "byteOffset", "", "dest", "Ljava/nio/ByteBuffer;", "write", "src", "Companion", "libaums_release"})
public class ByteBlockDevice
implements BlockDeviceDriver {
    private final BlockDeviceDriver targetBlockDevice;
    private final int logicalOffsetToAdd;
    private static final String TAG;
    public static final Companion Companion;

    @Override
    public int getBlockSize() {
        return this.targetBlockDevice.getBlockSize();
    }

    @Override
    public void init() throws IOException {
        this.targetBlockDevice.init();
    }

    @Override
    public void read(long byteOffset, @NotNull ByteBuffer dest) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        long devOffset = byteOffset / (long)this.getBlockSize() + (long)this.logicalOffsetToAdd;
        if (byteOffset % (long)this.getBlockSize() != 0L) {
            ByteBuffer tmp;
            ByteBuffer byteBuffer = tmp = ByteBuffer.allocate(this.getBlockSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"tmp");
            this.targetBlockDevice.read(devOffset, byteBuffer);
            tmp.clear();
            tmp.position((int)(byteOffset % (long)this.getBlockSize()));
            int limit = Math.min(dest.remaining(), tmp.remaining());
            tmp.limit(tmp.position() + limit);
            dest.put(tmp);
            long l = devOffset;
            devOffset = l + 1L;
        }
        if (dest.remaining() > 0) {
            ByteBuffer buffer = null;
            if (dest.remaining() % this.getBlockSize() != 0) {
                int rounded = this.getBlockSize() - dest.remaining() % this.getBlockSize() + dest.remaining();
                ByteBuffer byteBuffer = ByteBuffer.allocate(rounded);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocate(rounded)");
                buffer = byteBuffer;
                buffer.limit(rounded);
            } else {
                buffer = dest;
            }
            this.targetBlockDevice.read(devOffset, buffer);
            if (dest.remaining() % this.getBlockSize() != 0) {
                System.arraycopy(buffer.array(), 0, dest.array(), dest.position(), dest.remaining());
            }
            dest.position(dest.limit());
        }
    }

    @Override
    public void write(long byteOffset, @NotNull ByteBuffer src) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        long devOffset = byteOffset / (long)this.getBlockSize() + (long)this.logicalOffsetToAdd;
        if (byteOffset % (long)this.getBlockSize() != 0L) {
            ByteBuffer tmp;
            ByteBuffer byteBuffer = tmp = ByteBuffer.allocate(this.getBlockSize());
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"tmp");
            this.targetBlockDevice.read(devOffset, byteBuffer);
            tmp.clear();
            tmp.position((int)(byteOffset % (long)this.getBlockSize()));
            int remaining = Math.min(tmp.remaining(), src.remaining());
            tmp.put(src.array(), src.position(), remaining);
            src.position(src.position() + remaining);
            tmp.clear();
            this.targetBlockDevice.write(devOffset, tmp);
            long l = devOffset;
            devOffset = l + 1L;
        }
        if (src.remaining() > 0) {
            ByteBuffer buffer = null;
            if (src.remaining() % this.getBlockSize() != 0) {
                int rounded = this.getBlockSize() - src.remaining() % this.getBlockSize() + src.remaining();
                ByteBuffer byteBuffer = ByteBuffer.allocate(rounded);
                Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.allocate(rounded)");
                buffer = byteBuffer;
                buffer.limit(rounded);
                System.arraycopy(src.array(), src.position(), buffer.array(), 0, src.remaining());
                src.position(src.limit());
            } else {
                buffer = src;
            }
            this.targetBlockDevice.write(devOffset, buffer);
        }
    }

    @JvmOverloads
    public ByteBlockDevice(@NotNull BlockDeviceDriver targetBlockDevice, int logicalOffsetToAdd) {
        Intrinsics.checkParameterIsNotNull((Object)targetBlockDevice, (String)"targetBlockDevice");
        this.targetBlockDevice = targetBlockDevice;
        this.logicalOffsetToAdd = logicalOffsetToAdd;
    }

    public /* synthetic */ ByteBlockDevice(BlockDeviceDriver blockDeviceDriver, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(blockDeviceDriver, n);
    }

    @JvmOverloads
    public ByteBlockDevice(@NotNull BlockDeviceDriver targetBlockDevice) {
        this(targetBlockDevice, 0, 2, null);
    }

    static {
        Companion = new Companion(null);
        TAG = ByteBlockDevice.class.getSimpleName();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/mjdev/libaums/driver/ByteBlockDevice$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "libaums_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

