/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs.fat32;

import android.util.Log;
import com.github.mjdev.libaums.driver.BlockDeviceDriver;
import com.github.mjdev.libaums.fs.fat32.FAT;
import com.github.mjdev.libaums.fs.fat32.Fat32BootSector;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClusterChain {
    private static final String TAG = ClusterChain.class.getSimpleName();
    private BlockDeviceDriver blockDevice;
    private FAT fat;
    private Long[] chain;
    private long clusterSize;
    private long dataAreaOffset;

    ClusterChain(long startCluster, BlockDeviceDriver blockDevice, FAT fat, Fat32BootSector bootSector) throws IOException {
        Log.d((String)TAG, (String)"Init a cluster chain, reading from FAT");
        this.fat = fat;
        this.blockDevice = blockDevice;
        this.chain = fat.getChain(startCluster);
        this.clusterSize = bootSector.getBytesPerCluster();
        this.dataAreaOffset = bootSector.getDataAreaOffset();
        Log.d((String)TAG, (String)"Finished init of a cluster chain");
    }

    void read(long offset, ByteBuffer dest) throws IOException {
        int length = dest.remaining();
        int chainIndex = (int)(offset / this.clusterSize);
        if (offset % this.clusterSize != 0L) {
            int clusterOffset = (int)(offset % this.clusterSize);
            int size = Math.min(length, (int)(this.clusterSize - (long)clusterOffset));
            dest.limit(dest.position() + size);
            this.blockDevice.read(this.getFileSystemOffset(this.chain[chainIndex], clusterOffset), dest);
            ++chainIndex;
            length -= size;
        }
        while (length > 0) {
            int size = (int)Math.min(this.clusterSize, (long)length);
            dest.limit(dest.position() + size);
            this.blockDevice.read(this.getFileSystemOffset(this.chain[chainIndex], 0), dest);
            ++chainIndex;
            length -= size;
        }
    }

    void write(long offset, ByteBuffer source) throws IOException {
        int length = source.remaining();
        int chainIndex = (int)(offset / this.clusterSize);
        if (offset % this.clusterSize != 0L) {
            int clusterOffset = (int)(offset % this.clusterSize);
            int size = Math.min(length, (int)(this.clusterSize - (long)clusterOffset));
            source.limit(source.position() + size);
            this.blockDevice.write(this.getFileSystemOffset(this.chain[chainIndex], clusterOffset), source);
            ++chainIndex;
            length -= size;
        }
        while (length > 0) {
            int size = (int)Math.min(this.clusterSize, (long)length);
            source.limit(source.position() + size);
            this.blockDevice.write(this.getFileSystemOffset(this.chain[chainIndex], 0), source);
            ++chainIndex;
            length -= size;
        }
    }

    private long getFileSystemOffset(long cluster, int clusterOffset) {
        return this.dataAreaOffset + (long)clusterOffset + (cluster - 2L) * this.clusterSize;
    }

    void setClusters(int newNumberOfClusters) throws IOException {
        int oldNumberOfClusters = this.getClusters();
        if (newNumberOfClusters == oldNumberOfClusters) {
            return;
        }
        if (newNumberOfClusters > oldNumberOfClusters) {
            Log.d((String)TAG, (String)"grow chain");
            this.chain = this.fat.alloc(this.chain, newNumberOfClusters - oldNumberOfClusters);
        } else {
            Log.d((String)TAG, (String)"shrink chain");
            this.chain = this.fat.free(this.chain, oldNumberOfClusters - newNumberOfClusters);
        }
    }

    int getClusters() {
        return this.chain.length;
    }

    void setLength(long newLength) throws IOException {
        long newNumberOfClusters = (newLength + this.clusterSize - 1L) / this.clusterSize;
        this.setClusters((int)newNumberOfClusters);
    }

    long getLength() {
        return (long)this.chain.length * this.clusterSize;
    }
}

