/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbRequest;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;

class UsbRequestCommunication
implements UsbCommunication {
    private UsbDeviceConnection deviceConnection;
    private UsbRequest outRequest;
    private UsbRequest inRequest;
    private ByteBuffer workaroundBuffer = ByteBuffer.allocate(131072);

    UsbRequestCommunication(UsbDeviceConnection deviceConnection, UsbEndpoint outEndpoint, UsbEndpoint inEndpoint) {
        this.deviceConnection = deviceConnection;
        UsbRequest request = new UsbRequest();
        request.initialize(deviceConnection, outEndpoint);
        this.outRequest = request;
        request = new UsbRequest();
        request.initialize(deviceConnection, inEndpoint);
        this.inRequest = request;
    }

    @Override
    public synchronized int bulkOutTransfer(ByteBuffer src) throws IOException {
        int length = src.remaining();
        int oldPosition = src.position();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.put(src);
        if (!this.outRequest.queue(this.workaroundBuffer, length)) {
            throw new IOException("Error queueing request.");
        }
        UsbRequest request = this.deviceConnection.requestWait();
        if (request == this.outRequest) {
            src.position(oldPosition + this.workaroundBuffer.position());
            return this.workaroundBuffer.position();
        }
        throw new IOException("requestWait failed! Request: " + request);
    }

    @Override
    public synchronized int bulkInTransfer(ByteBuffer dest) throws IOException {
        int length = dest.remaining();
        this.workaroundBuffer.clear();
        this.workaroundBuffer.limit(length);
        if (!this.inRequest.queue(this.workaroundBuffer, length)) {
            throw new IOException("Error queueing request.");
        }
        UsbRequest request = this.deviceConnection.requestWait();
        if (request == this.inRequest) {
            this.workaroundBuffer.flip();
            dest.put(this.workaroundBuffer);
            return this.workaroundBuffer.limit();
        }
        throw new IOException("requestWait failed! Request: " + request);
    }
}

