/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.usb;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import com.github.mjdev.libaums.usb.UsbCommunication;
import java.io.IOException;
import java.nio.ByteBuffer;

class HoneyCombMr1Communication
implements UsbCommunication {
    private UsbDeviceConnection deviceConnection;
    private UsbEndpoint outEndpoint;
    private UsbEndpoint inEndpoint;

    HoneyCombMr1Communication(UsbDeviceConnection deviceConnection, UsbEndpoint outEndpoint, UsbEndpoint inEndpoint) {
        this.deviceConnection = deviceConnection;
        this.outEndpoint = outEndpoint;
        this.inEndpoint = inEndpoint;
    }

    @Override
    public int bulkOutTransfer(ByteBuffer src) throws IOException {
        int offset = src.position();
        if (offset == 0) {
            int result = this.deviceConnection.bulkTransfer(this.outEndpoint, src.array(), src.remaining(), 5000);
            if (result == -1) {
                throw new IOException("Could not write to device, result == -1");
            }
            src.position(src.position() + result);
            return result;
        }
        byte[] tmpBuffer = new byte[src.remaining()];
        System.arraycopy(src.array(), offset, tmpBuffer, 0, src.remaining());
        int result = this.deviceConnection.bulkTransfer(this.outEndpoint, tmpBuffer, src.remaining(), 5000);
        if (result == -1) {
            throw new IOException("Could not write to device, result == -1");
        }
        src.position(src.position() + result);
        return result;
    }

    @Override
    public int bulkInTransfer(ByteBuffer dest) throws IOException {
        int offset = dest.position();
        if (offset == 0) {
            int result = this.deviceConnection.bulkTransfer(this.inEndpoint, dest.array(), dest.remaining(), 5000);
            if (result == -1) {
                throw new IOException("Could read from to device, result == -1");
            }
            dest.position(dest.position() + result);
            return result;
        }
        byte[] tmpBuffer = new byte[dest.remaining()];
        int result = this.deviceConnection.bulkTransfer(this.inEndpoint, tmpBuffer, dest.remaining(), 5000);
        if (result == -1) {
            throw new IOException("Could not read from device, result == -1");
        }
        System.arraycopy(tmpBuffer, 0, dest.array(), offset, result);
        dest.position(dest.position() + result);
        return result;
    }
}

