/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.fs;

import android.support.annotation.NonNull;
import com.github.mjdev.libaums.fs.UsbFile;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class UsbFileOutputStream
extends OutputStream {
    private UsbFile file;
    private int currentByteOffset = 0;

    public UsbFileOutputStream(@NonNull UsbFile file) {
        if (file.isDirectory()) {
            throw new RuntimeException("UsbFileOutputStream cannot be created on directory!");
        }
        this.file = file;
    }

    @Override
    public void write(int oneByte) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[]{(byte)oneByte});
        this.file.write(this.currentByteOffset, byteBuffer);
        ++this.currentByteOffset;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public void flush() throws IOException {
        this.file.flush();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.file.write(this.currentByteOffset, byteBuffer);
        this.currentByteOffset += buffer.length;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.position(offset);
        byteBuffer.limit(count + offset);
        this.file.write(this.currentByteOffset, byteBuffer);
        this.currentByteOffset += count;
    }
}

