/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.driver.scsi.commands;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ScsiInquiryResponse {
    private byte peripheralQualifier;
    private byte peripheralDeviceType;
    boolean removableMedia;
    byte spcVersion;
    byte responseDataFormat;

    private ScsiInquiryResponse() {
    }

    public static ScsiInquiryResponse read(ByteBuffer buffer) {
        ScsiInquiryResponse response = new ScsiInquiryResponse();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        byte b = buffer.get();
        response.peripheralQualifier = (byte)(b & 0xFFFFFFE0);
        response.peripheralDeviceType = (byte)(b & 0x1F);
        response.removableMedia = buffer.get() == 128;
        response.spcVersion = buffer.get();
        response.responseDataFormat = (byte)(buffer.get() & 7);
        return response;
    }

    public byte getPeripheralQualifier() {
        return this.peripheralQualifier;
    }

    public byte getPeripheralDeviceType() {
        return this.peripheralDeviceType;
    }

    public boolean isRemovableMedia() {
        return this.removableMedia;
    }

    public byte getSpcVersion() {
        return this.spcVersion;
    }

    public byte getResponseDataFormat() {
        return this.responseDataFormat;
    }

    public String toString() {
        return "ScsiInquiryResponse [peripheralQualifier=" + this.peripheralQualifier + ", peripheralDeviceType=" + this.peripheralDeviceType + ", removableMedia=" + this.removableMedia + ", spcVersion=" + this.spcVersion + ", responseDataFormat=" + this.responseDataFormat + "]";
    }
}

