/*
 * Decompiled with CFR 0.152.
 */
package ca.mimic.oauth2library;

import ca.mimic.oauth2library.AuthState;
import ca.mimic.oauth2library.OAuth2Client;
import ca.mimic.oauth2library.OAuthResponse;
import ca.mimic.oauth2library.Utils;
import java.io.IOException;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Access {
    protected static OAuthResponse refreshAccessToken(String token, OAuth2Client oAuth2Client) throws IOException {
        FormBody.Builder formBodyBuilder = new FormBody.Builder().add("refresh_token", token);
        Utils.postAddIfValid(formBodyBuilder, oAuth2Client.getFieldsAsMap());
        Request request = new Request.Builder().url(oAuth2Client.getSite()).post((RequestBody)formBodyBuilder.build()).build();
        return Access.refreshTokenFromResponse(oAuth2Client, request);
    }

    private static OAuthResponse refreshTokenFromResponse(OAuth2Client oAuth2Client, Request request) throws IOException {
        return Access.getTokenFromResponse(oAuth2Client, oAuth2Client.getOkHttpClient(), request, new AuthState(1));
    }

    protected static OAuthResponse getToken(OAuth2Client oAuth2Client) throws IOException {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        Utils.postAddIfValid(formBodyBuilder, oAuth2Client.getFieldsAsMap());
        Utils.postAddIfValid(formBodyBuilder, oAuth2Client.getParameters());
        return Access.getAccessToken(oAuth2Client, formBodyBuilder);
    }

    private static OAuthResponse getAccessToken(OAuth2Client oAuth2Client, FormBody.Builder formBodyBuilder) throws IOException {
        Request request = new Request.Builder().url(oAuth2Client.getSite()).post((RequestBody)formBodyBuilder.build()).build();
        return Access.getTokenFromResponse(oAuth2Client, request);
    }

    private static OAuthResponse getTokenFromResponse(OAuth2Client oAuth2Client, Request request) throws IOException {
        return Access.getTokenFromResponse(oAuth2Client, oAuth2Client.getOkHttpClient(), request, new AuthState(0));
    }

    private static OAuthResponse getTokenFromResponse(OAuth2Client oAuth2Client, OkHttpClient okHttpClient, Request request, AuthState authState) throws IOException {
        Response response = okHttpClient.newBuilder().authenticator(Utils.getAuthenticator(oAuth2Client, authState)).build().newCall(request).execute();
        return new OAuthResponse(response);
    }
}

