/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbRequest;
import android.os.Build;
import android.util.Log;
import com.hoho.android.usbserial.driver.SerialTimeoutException;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import com.hoho.android.usbserial.util.MonotonicClock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;

public abstract class CommonUsbSerialPort
implements UsbSerialPort {
    public static boolean DEBUG = false;
    private static final String TAG = CommonUsbSerialPort.class.getSimpleName();
    private static final int MAX_READ_SIZE = 16384;
    protected final UsbDevice mDevice;
    protected final int mPortNumber;
    protected UsbDeviceConnection mConnection;
    protected UsbEndpoint mReadEndpoint;
    protected UsbEndpoint mWriteEndpoint;
    protected UsbRequest mUsbRequest;
    protected UsbSerialPort.FlowControl mFlowControl = UsbSerialPort.FlowControl.NONE;
    protected byte[] mWriteBuffer;
    protected final Object mWriteBufferLock = new Object();

    public CommonUsbSerialPort(UsbDevice device, int portNumber) {
        this.mDevice = device;
        this.mPortNumber = portNumber;
    }

    public String toString() {
        return String.format("<%s device_name=%s device_id=%s port_number=%s>", this.getClass().getSimpleName(), this.mDevice.getDeviceName(), this.mDevice.getDeviceId(), this.mPortNumber);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public int getPortNumber() {
        return this.mPortNumber;
    }

    @Override
    public UsbEndpoint getWriteEndpoint() {
        return this.mWriteEndpoint;
    }

    @Override
    public UsbEndpoint getReadEndpoint() {
        return this.mReadEndpoint;
    }

    @Override
    public String getSerial() {
        return this.mConnection.getSerial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setWriteBufferSize(int bufferSize) {
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            if (bufferSize <= 0) {
                if (this.mWriteEndpoint != null) {
                    bufferSize = this.mWriteEndpoint.getMaxPacketSize();
                } else {
                    this.mWriteBuffer = null;
                    return;
                }
            }
            if (this.mWriteBuffer != null && bufferSize == this.mWriteBuffer.length) {
                return;
            }
            this.mWriteBuffer = new byte[bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(UsbDeviceConnection connection) throws IOException {
        if (this.mConnection != null) {
            throw new IOException("Already open");
        }
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        this.mConnection = connection;
        boolean ok = false;
        try {
            this.openInt();
            if (this.mReadEndpoint == null || this.mWriteEndpoint == null) {
                throw new IOException("Could not get read & write endpoints");
            }
            this.mUsbRequest = new UsbRequest();
            this.mUsbRequest.initialize(this.mConnection, this.mReadEndpoint);
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    this.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected abstract void openInt() throws IOException;

    @Override
    public void close() throws IOException {
        if (this.mConnection == null) {
            throw new IOException("Already closed");
        }
        UsbRequest usbRequest = this.mUsbRequest;
        this.mUsbRequest = null;
        try {
            usbRequest.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mConnection = null;
    }

    protected abstract void closeInt();

    protected void testConnection(boolean full) throws IOException {
        this.testConnection(full, "USB get_status request failed");
    }

    protected void testConnection(boolean full, String msg) throws IOException {
        if (this.mUsbRequest == null) {
            throw new IOException("Connection closed");
        }
        if (!full) {
            return;
        }
        byte[] buf = new byte[2];
        int len = this.mConnection.controlTransfer(128, 0, 0, 0, buf, buf.length, 200);
        if (len < 0) {
            throw new IOException(msg);
        }
    }

    @Override
    public int read(byte[] dest, int timeout) throws IOException {
        if (dest.length == 0) {
            throw new IllegalArgumentException("Read buffer too small");
        }
        return this.read(dest, dest.length, timeout);
    }

    @Override
    public int read(byte[] dest, int length, int timeout) throws IOException {
        return this.read(dest, length, timeout, true);
    }

    protected int read(byte[] dest, int length, int timeout, boolean testConnection) throws IOException {
        int nread;
        this.testConnection(false);
        if (length <= 0) {
            throw new IllegalArgumentException("Read length too small");
        }
        length = Math.min(length, dest.length);
        if (timeout != 0) {
            long endTime = testConnection ? MonotonicClock.millis() + (long)timeout : 0L;
            int readMax = Build.VERSION.SDK_INT >= 28 ? length : Math.min(length, 16384);
            nread = this.mConnection.bulkTransfer(this.mReadEndpoint, dest, readMax, timeout);
            if (nread == -1 && testConnection) {
                this.testConnection(MonotonicClock.millis() < endTime);
            }
        } else {
            ByteBuffer buf = ByteBuffer.wrap(dest, 0, length);
            if (!this.mUsbRequest.queue(buf, length)) {
                throw new IOException("Queueing USB request failed");
            }
            UsbRequest response = this.mConnection.requestWait();
            if (response == null) {
                throw new IOException("Waiting for USB request failed");
            }
            nread = buf.position();
            if (nread == 0) {
                this.testConnection(true);
            }
        }
        return Math.max(nread, 0);
    }

    @Override
    public void write(byte[] src, int timeout) throws IOException {
        this.write(src, src.length, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] src, int length, int timeout) throws IOException {
        int actualLength;
        long startTime = MonotonicClock.millis();
        length = Math.min(length, src.length);
        this.testConnection(false);
        for (int offset = 0; offset < length; offset += actualLength) {
            int requestTimeout;
            int requestLength;
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                byte[] writeBuffer;
                if (this.mWriteBuffer == null) {
                    this.mWriteBuffer = new byte[this.mWriteEndpoint.getMaxPacketSize()];
                }
                requestLength = Math.min(length - offset, this.mWriteBuffer.length);
                if (offset == 0) {
                    writeBuffer = src;
                } else {
                    System.arraycopy(src, offset, this.mWriteBuffer, 0, requestLength);
                    writeBuffer = this.mWriteBuffer;
                }
                if (timeout == 0 || offset == 0) {
                    requestTimeout = timeout;
                } else {
                    requestTimeout = (int)(startTime + (long)timeout - MonotonicClock.millis());
                    if (requestTimeout == 0) {
                        requestTimeout = -1;
                    }
                }
                actualLength = requestTimeout < 0 ? -2 : this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, requestLength, requestTimeout);
            }
            long elapsed = MonotonicClock.millis() - startTime;
            if (DEBUG) {
                Log.d((String)TAG, (String)("Wrote " + actualLength + "/" + requestLength + " offset " + offset + "/" + length + " time " + elapsed + "/" + requestTimeout));
            }
            if (actualLength > 0) continue;
            String msg = "Error writing " + requestLength + " bytes at offset " + offset + " of total " + src.length + " after " + elapsed + "msec, rc=" + actualLength;
            if (timeout != 0) {
                this.testConnection(elapsed < (long)timeout, msg);
                throw new SerialTimeoutException(msg, offset);
            }
            throw new IOException(msg);
        }
    }

    @Override
    public boolean isOpen() {
        return this.mUsbRequest != null;
    }

    @Override
    public abstract void setParameters(int var1, int var2, int var3, int var4) throws IOException;

    @Override
    public boolean getCD() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getCTS() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDSR() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getDTR() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDTR(boolean value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getRI() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getRTS() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRTS(boolean value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EnumSet<UsbSerialPort.ControlLine> getControlLines() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException {
        return EnumSet.noneOf(UsbSerialPort.ControlLine.class);
    }

    @Override
    public void setFlowControl(UsbSerialPort.FlowControl flowcontrol) throws IOException {
        if (flowcontrol != UsbSerialPort.FlowControl.NONE) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public UsbSerialPort.FlowControl getFlowControl() {
        return this.mFlowControl;
    }

    @Override
    public EnumSet<UsbSerialPort.FlowControl> getSupportedFlowControl() {
        return EnumSet.of(UsbSerialPort.FlowControl.NONE);
    }

    @Override
    public boolean getXON() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void purgeHwBuffers(boolean purgeWriteBuffers, boolean purgeReadBuffers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBreak(boolean value) throws IOException {
        throw new UnsupportedOperationException();
    }
}

