/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChromeCcdSerialDriver
implements UsbSerialDriver {
    private final String TAG = ChromeCcdSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final List<UsbSerialPort> mPorts;

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return this.mPorts;
    }

    public ChromeCcdSerialDriver(UsbDevice mDevice) {
        this.mDevice = mDevice;
        this.mPorts = new ArrayList<UsbSerialPort>();
        for (int i = 0; i < 3; ++i) {
            this.mPorts.add(new ChromeCcdSerialPort(mDevice, i));
        }
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(6353, new int[]{20500});
        return supportedDevices;
    }

    public class ChromeCcdSerialPort
    extends CommonUsbSerialPort {
        private UsbInterface mDataInterface;

        public ChromeCcdSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
        }

        @Override
        protected void openInt() throws IOException {
            Log.d((String)ChromeCcdSerialDriver.this.TAG, (String)("claiming interfaces, count=" + this.mDevice.getInterfaceCount()));
            this.mDataInterface = this.mDevice.getInterface(this.mPortNumber);
            if (!this.mConnection.claimInterface(this.mDataInterface, true)) {
                throw new IOException("Could not claim shared control/data interface");
            }
            Log.d((String)ChromeCcdSerialDriver.this.TAG, (String)("endpoint count=" + this.mDataInterface.getEndpointCount()));
            for (int i = 0; i < this.mDataInterface.getEndpointCount(); ++i) {
                UsbEndpoint ep = this.mDataInterface.getEndpoint(i);
                if (ep.getDirection() == 128 && ep.getType() == 2) {
                    this.mReadEndpoint = ep;
                    continue;
                }
                if (ep.getDirection() != 0 || ep.getType() != 2) continue;
                this.mWriteEndpoint = ep;
            }
        }

        @Override
        protected void closeInt() {
            try {
                this.mConnection.releaseInterface(this.mDataInterface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public UsbSerialDriver getDriver() {
            return ChromeCcdSerialDriver.this;
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException {
            return EnumSet.noneOf(UsbSerialPort.ControlLine.class);
        }
    }
}

