/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.util;

import android.os.Process;
import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class SerialInputOutputManager {
    public static boolean DEBUG = false;
    private static final String TAG = SerialInputOutputManager.class.getSimpleName();
    private static final int WRITE_BUFFER_SIZE = 4096;
    private int mReadTimeout = 0;
    private int mWriteTimeout = 0;
    private int mReadQueueBufferCount = 0;
    private final Object mReadBufferLock = new Object();
    private final Object mWriteBufferLock = new Object();
    private ByteBuffer mReadBuffer;
    private ByteBuffer mWriteBuffer = ByteBuffer.allocate(4096);
    private int mThreadPriority = -19;
    private final AtomicReference<State> mState = new AtomicReference<State>(State.STOPPED);
    private CountDownLatch mStartuplatch = new CountDownLatch(2);
    private Listener mListener;
    private final UsbSerialPort mSerialPort;

    public SerialInputOutputManager(UsbSerialPort serialPort) {
        this.mSerialPort = serialPort;
        this.mReadBuffer = ByteBuffer.allocate(serialPort.getReadEndpoint().getMaxPacketSize());
    }

    public SerialInputOutputManager(UsbSerialPort serialPort, Listener listener) {
        this(serialPort);
        this.mListener = listener;
    }

    public synchronized void setListener(Listener listener) {
        this.mListener = listener;
    }

    public synchronized Listener getListener() {
        return this.mListener;
    }

    public void setThreadPriority(int threadPriority) {
        if (!this.mState.compareAndSet(State.STOPPED, State.STOPPED)) {
            throw new IllegalStateException("threadPriority only configurable before SerialInputOutputManager is started");
        }
        this.mThreadPriority = threadPriority;
    }

    public void setReadTimeout(int timeout) {
        if (this.mReadTimeout == 0 && timeout != 0 && this.mState.get() != State.STOPPED) {
            throw new IllegalStateException("readTimeout only configurable before SerialInputOutputManager is started");
        }
        this.mReadTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public void setWriteTimeout(int timeout) {
        this.mWriteTimeout = timeout;
    }

    public int getWriteTimeout() {
        return this.mWriteTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadBufferSize(int bufferSize) {
        if (this.getReadBufferSize() == bufferSize) {
            return;
        }
        Object object = this.mReadBufferLock;
        synchronized (object) {
            this.mReadBuffer = ByteBuffer.allocate(bufferSize);
        }
    }

    public int getReadBufferSize() {
        return this.mReadBuffer.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteBufferSize(int bufferSize) {
        if (this.getWriteBufferSize() == bufferSize) {
            return;
        }
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            ByteBuffer newWriteBuffer = ByteBuffer.allocate(bufferSize);
            if (this.mWriteBuffer.position() > 0) {
                newWriteBuffer.put(this.mWriteBuffer.array(), 0, this.mWriteBuffer.position());
            }
            this.mWriteBuffer = newWriteBuffer;
        }
    }

    public int getWriteBufferSize() {
        return this.mWriteBuffer.capacity();
    }

    public void setReadQueue(int bufferCount) {
        this.mSerialPort.setReadQueue(bufferCount, this.getReadBufferSize());
        this.mReadQueueBufferCount = bufferCount;
    }

    public int getReadQueueBufferCount() {
        return this.mReadQueueBufferCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsync(byte[] data) {
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            this.mWriteBuffer.put(data);
            this.mWriteBufferLock.notifyAll();
        }
    }

    public void start() {
        this.mSerialPort.setReadQueue(this.mReadQueueBufferCount, this.getReadBufferSize());
        if (this.mState.compareAndSet(State.STOPPED, State.STARTING)) {
            this.mStartuplatch = new CountDownLatch(2);
            new Thread(this::runRead, this.getClass().getSimpleName() + "_read").start();
            new Thread(this::runWrite, this.getClass().getSimpleName() + "_write").start();
            try {
                this.mStartuplatch.await();
                this.mState.set(State.RUNNING);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            throw new IllegalStateException("already started");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.mState.compareAndSet(State.RUNNING, State.STOPPING)) {
            Object object = this.mWriteBufferLock;
            synchronized (object) {
                this.mWriteBufferLock.notifyAll();
            }
            Log.i((String)TAG, (String)"Stop requested");
        }
    }

    public State getState() {
        return this.mState.get();
    }

    private boolean isStillRunning() {
        State state = this.mState.get();
        return (state == State.RUNNING || state == State.STARTING) && !Thread.currentThread().isInterrupted();
    }

    private void notifyErrorListener(Throwable e) {
        Listener listener = this.getListener();
        if (listener != null) {
            try {
                listener.onRunError(e instanceof Exception ? (Exception)e : new Exception(e));
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("Exception in onRunError: " + t.getMessage()), (Throwable)t);
            }
        }
    }

    private void setThreadPriority() {
        if (this.mThreadPriority != 0) {
            Process.setThreadPriority((int)this.mThreadPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runRead() {
        Log.i((String)TAG, (String)"runRead running ...");
        try {
            this.setThreadPriority();
            this.mStartuplatch.countDown();
            do {
                this.stepRead();
            } while (this.isStillRunning());
            Log.i((String)TAG, (String)("runRead: Stopping mState=" + (Object)((Object)this.getState())));
        }
        catch (Throwable e) {
            if (Thread.currentThread().isInterrupted()) {
                Log.w((String)TAG, (String)"runRead: interrupted");
            } else if (this.mSerialPort.isOpen()) {
                Log.w((String)TAG, (String)("runRead ending due to exception: " + e.getMessage()), (Throwable)e);
            } else {
                Log.i((String)TAG, (String)"runRead: Socket closed");
            }
            this.notifyErrorListener(e);
        }
        finally {
            if (this.mState.compareAndSet(State.RUNNING, State.STOPPING)) {
                Object object = this.mWriteBufferLock;
                synchronized (object) {
                    this.mWriteBufferLock.notifyAll();
                }
            } else if (this.mState.compareAndSet(State.STOPPING, State.STOPPED)) {
                Log.i((String)TAG, (String)("runRead: Stopped mState=" + (Object)((Object)this.getState())));
            }
        }
    }

    void runWrite() {
        Log.i((String)TAG, (String)"runWrite running ...");
        try {
            this.setThreadPriority();
            this.mStartuplatch.countDown();
            do {
                this.stepWrite();
            } while (this.isStillRunning());
            Log.i((String)TAG, (String)("runWrite: Stopping mState=" + (Object)((Object)this.getState())));
        }
        catch (Throwable e) {
            if (Thread.currentThread().isInterrupted()) {
                Log.w((String)TAG, (String)"runWrite: interrupted");
            } else if (this.mSerialPort.isOpen()) {
                Log.w((String)TAG, (String)("runWrite ending due to exception: " + e.getMessage()), (Throwable)e);
            } else {
                Log.i((String)TAG, (String)"runWrite: Socket closed");
            }
            this.notifyErrorListener(e);
        }
        finally {
            if (!this.mState.compareAndSet(State.RUNNING, State.STOPPING) && this.mState.compareAndSet(State.STOPPING, State.STOPPED)) {
                Log.i((String)TAG, (String)("runWrite: Stopped mState=" + (Object)((Object)this.getState())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stepRead() throws IOException {
        byte[] buffer;
        Object object = this.mReadBufferLock;
        synchronized (object) {
            buffer = this.mReadBuffer.array();
        }
        int len = this.mSerialPort.read(buffer, this.mReadTimeout);
        if (len > 0) {
            Listener listener;
            if (DEBUG) {
                Log.d((String)TAG, (String)("Read data len=" + len));
            }
            if ((listener = this.getListener()) != null) {
                byte[] data = new byte[len];
                System.arraycopy(buffer, 0, data, 0, len);
                listener.onNewData(data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stepWrite() throws IOException, InterruptedException {
        byte[] buffer = null;
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            int len = this.mWriteBuffer.position();
            if (len > 0) {
                buffer = new byte[len];
                this.mWriteBuffer.rewind();
                this.mWriteBuffer.get(buffer, 0, len);
                this.mWriteBuffer.clear();
                this.mWriteBufferLock.notifyAll();
            } else {
                this.mWriteBufferLock.wait();
            }
        }
        if (buffer != null) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("Writing data len=" + buffer.length));
            }
            this.mSerialPort.write(buffer, this.mWriteTimeout);
        }
    }

    public static enum State {
        STOPPED,
        STARTING,
        RUNNING,
        STOPPING;

    }

    public static interface Listener {
        public void onNewData(byte[] var1);

        public void onRunError(Exception var1);
    }
}

