/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CdcAcmSerialDriver
implements UsbSerialDriver {
    private final String TAG = CdcAcmSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final List<UsbSerialPort> mPorts;

    public CdcAcmSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPorts = new ArrayList<UsbSerialPort>();
        int controlInterfaceCount = 0;
        int dataInterfaceCount = 0;
        for (int i = 0; i < device.getInterfaceCount(); ++i) {
            if (device.getInterface(i).getInterfaceClass() == 2) {
                ++controlInterfaceCount;
            }
            if (device.getInterface(i).getInterfaceClass() != 10) continue;
            ++dataInterfaceCount;
        }
        for (int port = 0; port < Math.min(controlInterfaceCount, dataInterfaceCount); ++port) {
            this.mPorts.add(new CdcAcmSerialPort(this.mDevice, port));
        }
        if (this.mPorts.size() == 0) {
            this.mPorts.add(new CdcAcmSerialPort(this.mDevice, -1));
        }
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return this.mPorts;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(9025, new int[]{1, 67, 16, 66, 59, 68, 63, 68, 32822, 32823});
        supportedDevices.put(5824, new int[]{1155});
        supportedDevices.put(1003, new int[]{8260});
        supportedDevices.put(7855, new int[]{4});
        supportedDevices.put(3368, new int[]{516});
        return supportedDevices;
    }

    public class CdcAcmSerialPort
    extends CommonUsbSerialPort {
        private UsbInterface mControlInterface;
        private UsbInterface mDataInterface;
        private UsbEndpoint mControlEndpoint;
        private int mControlIndex;
        private boolean mRts;
        private boolean mDtr;
        private static final int USB_RECIP_INTERFACE = 1;
        private static final int USB_RT_ACM = 33;
        private static final int SET_LINE_CODING = 32;
        private static final int GET_LINE_CODING = 33;
        private static final int SET_CONTROL_LINE_STATE = 34;
        private static final int SEND_BREAK = 35;

        public CdcAcmSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.mRts = false;
            this.mDtr = false;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return CdcAcmSerialDriver.this;
        }

        @Override
        protected void openInt(UsbDeviceConnection connection) throws IOException {
            if (this.mPortNumber == -1) {
                Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"device might be castrated ACM device, trying single interface logic");
                this.openSingleInterface();
            } else {
                Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"trying default interface logic");
                this.openInterface();
            }
        }

        private void openSingleInterface() throws IOException {
            this.mControlIndex = 0;
            this.mControlInterface = this.mDevice.getInterface(0);
            this.mDataInterface = this.mDevice.getInterface(0);
            if (!this.mConnection.claimInterface(this.mControlInterface, true)) {
                throw new IOException("Could not claim shared control/data interface");
            }
            for (int i = 0; i < this.mControlInterface.getEndpointCount(); ++i) {
                UsbEndpoint ep = this.mControlInterface.getEndpoint(i);
                if (ep.getDirection() == 128 && ep.getType() == 3) {
                    this.mControlEndpoint = ep;
                    continue;
                }
                if (ep.getDirection() == 128 && ep.getType() == 2) {
                    this.mReadEndpoint = ep;
                    continue;
                }
                if (ep.getDirection() != 0 || ep.getType() != 2) continue;
                this.mWriteEndpoint = ep;
            }
            if (this.mControlEndpoint == null) {
                throw new IOException("No control endpoint");
            }
        }

        private void openInterface() throws IOException {
            int i;
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("claiming interfaces, count=" + this.mDevice.getInterfaceCount()));
            int controlInterfaceCount = 0;
            int dataInterfaceCount = 0;
            this.mControlInterface = null;
            this.mDataInterface = null;
            for (i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                UsbInterface usbInterface = this.mDevice.getInterface(i);
                if (usbInterface.getInterfaceClass() == 2) {
                    if (controlInterfaceCount == this.mPortNumber) {
                        this.mControlIndex = i;
                        this.mControlInterface = usbInterface;
                    }
                    ++controlInterfaceCount;
                }
                if (usbInterface.getInterfaceClass() != 10) continue;
                if (dataInterfaceCount == this.mPortNumber) {
                    this.mDataInterface = usbInterface;
                }
                ++dataInterfaceCount;
            }
            if (this.mControlInterface == null) {
                throw new IOException("No control interface");
            }
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("Control iface=" + this.mControlInterface));
            if (!this.mConnection.claimInterface(this.mControlInterface, true)) {
                throw new IOException("Could not claim control interface");
            }
            this.mControlEndpoint = this.mControlInterface.getEndpoint(0);
            if (this.mControlEndpoint.getDirection() != 128 || this.mControlEndpoint.getType() != 3) {
                throw new IOException("Invalid control endpoint");
            }
            if (this.mDataInterface == null) {
                throw new IOException("No data interface");
            }
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("data iface=" + this.mDataInterface));
            if (!this.mConnection.claimInterface(this.mDataInterface, true)) {
                throw new IOException("Could not claim data interface");
            }
            for (i = 0; i < this.mDataInterface.getEndpointCount(); ++i) {
                UsbEndpoint ep = this.mDataInterface.getEndpoint(i);
                if (ep.getDirection() == 128 && ep.getType() == 2) {
                    this.mReadEndpoint = ep;
                }
                if (ep.getDirection() != 0 || ep.getType() != 2) continue;
                this.mWriteEndpoint = ep;
            }
        }

        private int sendAcmControlMessage(int request, int value, byte[] buf) throws IOException {
            int len = this.mConnection.controlTransfer(33, request, value, this.mControlIndex, buf, buf != null ? buf.length : 0, 5000);
            if (len < 0) {
                throw new IOException("controlTransfer failed");
            }
            return len;
        }

        @Override
        protected void closeInt() {
            try {
                this.mConnection.releaseInterface(this.mControlInterface);
                this.mConnection.releaseInterface(this.mDataInterface);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            byte parityBitesByte;
            byte stopBitsByte;
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            if (dataBits < 5 || dataBits > 8) {
                throw new IllegalArgumentException("Invalid data bits: " + dataBits);
            }
            switch (stopBits) {
                case 1: {
                    stopBitsByte = 0;
                    break;
                }
                case 3: {
                    stopBitsByte = 1;
                    break;
                }
                case 2: {
                    stopBitsByte = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            switch (parity) {
                case 0: {
                    parityBitesByte = 0;
                    break;
                }
                case 1: {
                    parityBitesByte = 1;
                    break;
                }
                case 2: {
                    parityBitesByte = 2;
                    break;
                }
                case 3: {
                    parityBitesByte = 3;
                    break;
                }
                case 4: {
                    parityBitesByte = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            byte[] msg = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF), stopBitsByte, parityBitesByte, (byte)dataBits};
            this.sendAcmControlMessage(32, 0, msg);
        }

        @Override
        public boolean getCD() throws IOException {
            return false;
        }

        @Override
        public boolean getCTS() throws IOException {
            return false;
        }

        @Override
        public boolean getDSR() throws IOException {
            return false;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.mDtr;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            this.mDtr = value;
            this.setDtrRts();
        }

        @Override
        public boolean getRI() throws IOException {
            return false;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.mRts;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            this.mRts = value;
            this.setDtrRts();
        }

        private void setDtrRts() throws IOException {
            int value = (this.mRts ? 2 : 0) | (this.mDtr ? 1 : 0);
            this.sendAcmControlMessage(34, value, null);
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getControlLines() throws IOException {
            EnumSet<UsbSerialPort.ControlLine> set = EnumSet.noneOf(UsbSerialPort.ControlLine.class);
            if (this.mRts) {
                set.add(UsbSerialPort.ControlLine.RTS);
            }
            if (this.mDtr) {
                set.add(UsbSerialPort.ControlLine.DTR);
            }
            return set;
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException {
            return EnumSet.of(UsbSerialPort.ControlLine.RTS, UsbSerialPort.ControlLine.DTR);
        }
    }
}

