/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Cp21xxSerialDriver
implements UsbSerialDriver {
    private static final String TAG = Cp21xxSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final List<UsbSerialPort> mPorts;

    public Cp21xxSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPorts = new ArrayList<UsbSerialPort>();
        for (int port = 0; port < device.getInterfaceCount(); ++port) {
            this.mPorts.add(new Cp21xxSerialPort(this.mDevice, port));
        }
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return this.mPorts;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(4292, new int[]{60000, 60016, 60017, 60032});
        return supportedDevices;
    }

    public class Cp21xxSerialPort
    extends CommonUsbSerialPort {
        private static final int DEFAULT_BAUD_RATE = 9600;
        private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
        private static final int REQTYPE_HOST_TO_DEVICE = 65;
        private static final int SILABSER_IFC_ENABLE_REQUEST_CODE = 0;
        private static final int SILABSER_SET_BAUDDIV_REQUEST_CODE = 1;
        private static final int SILABSER_SET_LINE_CTL_REQUEST_CODE = 3;
        private static final int SILABSER_SET_MHS_REQUEST_CODE = 7;
        private static final int SILABSER_SET_BAUDRATE = 30;
        private static final int SILABSER_FLUSH_REQUEST_CODE = 18;
        private static final int FLUSH_READ_CODE = 10;
        private static final int FLUSH_WRITE_CODE = 5;
        private static final int UART_ENABLE = 1;
        private static final int UART_DISABLE = 0;
        private static final int BAUD_RATE_GEN_FREQ = 3686400;
        private static final int MCR_DTR = 1;
        private static final int MCR_RTS = 2;
        private static final int MCR_ALL = 3;
        private static final int CONTROL_WRITE_DTR = 256;
        private static final int CONTROL_WRITE_RTS = 512;
        private UsbEndpoint mReadEndpoint;
        private UsbEndpoint mWriteEndpoint;
        private UsbRequest mUsbRequest;
        private boolean mIsRestrictedPort;

        public Cp21xxSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
        }

        @Override
        public UsbSerialDriver getDriver() {
            return Cp21xxSerialDriver.this;
        }

        private int setConfigSingle(int request, int value) {
            return this.mConnection.controlTransfer(65, request, value, this.mPortNumber, null, 0, 5000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open(UsbDeviceConnection connection) throws IOException {
            if (this.mConnection != null) {
                throw new IOException("Already opened.");
            }
            this.mConnection = connection;
            boolean opened = false;
            this.mIsRestrictedPort = this.mDevice.getInterfaceCount() == 2 && this.mPortNumber == 1;
            try {
                if (this.mPortNumber >= this.mDevice.getInterfaceCount()) {
                    throw new IOException("Unknown port number");
                }
                UsbInterface dataIface = this.mDevice.getInterface(this.mPortNumber);
                if (!this.mConnection.claimInterface(dataIface, true)) {
                    throw new IOException("Could not claim interface " + this.mPortNumber);
                }
                for (int i = 0; i < dataIface.getEndpointCount(); ++i) {
                    UsbEndpoint ep = dataIface.getEndpoint(i);
                    if (ep.getType() != 2) continue;
                    if (ep.getDirection() == 128) {
                        this.mReadEndpoint = ep;
                        continue;
                    }
                    this.mWriteEndpoint = ep;
                }
                this.setConfigSingle(0, 1);
                this.setConfigSingle(7, 771);
                this.setConfigSingle(1, 384);
                opened = true;
            }
            finally {
                if (!opened) {
                    try {
                        this.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.mConnection == null) {
                throw new IOException("Already closed");
            }
            Cp21xxSerialPort cp21xxSerialPort = this;
            synchronized (cp21xxSerialPort) {
                if (this.mUsbRequest != null) {
                    this.mUsbRequest.cancel();
                }
            }
            try {
                this.setConfigSingle(0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.mConnection.close();
            }
            finally {
                this.mConnection = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] dest, int timeoutMillis) throws IOException {
            UsbRequest request = new UsbRequest();
            try {
                request.initialize(this.mConnection, this.mReadEndpoint);
                ByteBuffer buf = ByteBuffer.wrap(dest);
                if (!request.queue(buf, dest.length)) {
                    throw new IOException("Error queueing request.");
                }
                this.mUsbRequest = request;
                UsbRequest response = this.mConnection.requestWait();
                Cp21xxSerialPort cp21xxSerialPort = this;
                synchronized (cp21xxSerialPort) {
                    this.mUsbRequest = null;
                }
                if (response == null) {
                    throw new IOException("Null response");
                }
                int nread = buf.position();
                if (nread > 0) {
                    int n = nread;
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                this.mUsbRequest = null;
                request.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(byte[] src, int timeoutMillis) throws IOException {
            int offset;
            int amtWritten;
            for (offset = 0; offset < src.length; offset += amtWritten) {
                int writeLength;
                Object object = this.mWriteBufferLock;
                synchronized (object) {
                    byte[] writeBuffer;
                    writeLength = Math.min(src.length - offset, this.mWriteBuffer.length);
                    if (offset == 0) {
                        writeBuffer = src;
                    } else {
                        System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                        writeBuffer = this.mWriteBuffer;
                    }
                    amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeoutMillis);
                }
                if (amtWritten <= 0) {
                    throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
                }
                Log.d((String)TAG, (String)("Wrote amt=" + amtWritten + " attempted=" + writeLength));
            }
            return offset;
        }

        private void setBaudRate(int baudRate) throws IOException {
            byte[] data = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF)};
            int ret = this.mConnection.controlTransfer(65, 30, 0, this.mPortNumber, data, 4, 5000);
            if (ret < 0) {
                throw new IOException("Error setting baud rate.");
            }
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            this.setBaudRate(baudRate);
            int configDataBits = 0;
            switch (dataBits) {
                case 5: {
                    if (this.mIsRestrictedPort) {
                        throw new IllegalArgumentException("Unsupported dataBits value: " + dataBits);
                    }
                    configDataBits |= 0x500;
                    break;
                }
                case 6: {
                    if (this.mIsRestrictedPort) {
                        throw new IllegalArgumentException("Unsupported dataBits value: " + dataBits);
                    }
                    configDataBits |= 0x600;
                    break;
                }
                case 7: {
                    if (this.mIsRestrictedPort) {
                        throw new IllegalArgumentException("Unsupported dataBits value: " + dataBits);
                    }
                    configDataBits |= 0x700;
                    break;
                }
                case 8: {
                    configDataBits |= 0x800;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown dataBits value: " + dataBits);
                }
            }
            switch (parity) {
                case 0: {
                    break;
                }
                case 1: {
                    configDataBits |= 0x10;
                    break;
                }
                case 2: {
                    configDataBits |= 0x20;
                    break;
                }
                case 3: {
                    if (this.mIsRestrictedPort) {
                        throw new IllegalArgumentException("Unsupported parity value: mark");
                    }
                    configDataBits |= 0x30;
                    break;
                }
                case 4: {
                    if (this.mIsRestrictedPort) {
                        throw new IllegalArgumentException("Unsupported parity value: space");
                    }
                    configDataBits |= 0x40;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown parity value: " + parity);
                }
            }
            switch (stopBits) {
                case 1: {
                    break;
                }
                case 3: {
                    throw new IllegalArgumentException("Unsupported stopBits value: 1.5");
                }
                case 2: {
                    if (this.mIsRestrictedPort) {
                        throw new IllegalArgumentException("Unsupported stopBits value: 2");
                    }
                    configDataBits |= 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown stopBits value: " + stopBits);
                }
            }
            this.setConfigSingle(3, configDataBits);
        }

        @Override
        public boolean getCD() throws IOException {
            return false;
        }

        @Override
        public boolean getCTS() throws IOException {
            return false;
        }

        @Override
        public boolean getDSR() throws IOException {
            return false;
        }

        @Override
        public boolean getDTR() throws IOException {
            return true;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
        }

        @Override
        public boolean getRI() throws IOException {
            return false;
        }

        @Override
        public boolean getRTS() throws IOException {
            return true;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
        }

        @Override
        public boolean purgeHwBuffers(boolean purgeReadBuffers, boolean purgeWriteBuffers) throws IOException {
            int value = (purgeReadBuffers ? 10 : 0) | (purgeWriteBuffers ? 5 : 0);
            if (value != 0) {
                this.setConfigSingle(18, value);
            }
            return true;
        }
    }
}

