/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.util;

import android.os.Process;
import android.util.Log;
import com.hoho.android.usbserial.driver.SerialTimeoutException;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SerialInputOutputManager
implements Runnable {
    public static boolean DEBUG = false;
    private static final String TAG = SerialInputOutputManager.class.getSimpleName();
    private static final int BUFSIZ = 4096;
    private int mReadTimeout = 0;
    private int mWriteTimeout = 0;
    private final Object mReadBufferLock = new Object();
    private final Object mWriteBufferLock = new Object();
    private ByteBuffer mReadBuffer;
    private ByteBuffer mWriteBuffer = ByteBuffer.allocate(4096);
    private int mThreadPriority = -19;
    private State mState = State.STOPPED;
    private Listener mListener;
    private final UsbSerialPort mSerialPort;

    public SerialInputOutputManager(UsbSerialPort serialPort) {
        this.mSerialPort = serialPort;
        this.mReadBuffer = ByteBuffer.allocate(serialPort.getReadEndpoint().getMaxPacketSize());
    }

    public SerialInputOutputManager(UsbSerialPort serialPort, Listener listener) {
        this.mSerialPort = serialPort;
        this.mListener = listener;
        this.mReadBuffer = ByteBuffer.allocate(serialPort.getReadEndpoint().getMaxPacketSize());
    }

    public synchronized void setListener(Listener listener) {
        this.mListener = listener;
    }

    public synchronized Listener getListener() {
        return this.mListener;
    }

    public void setThreadPriority(int threadPriority) {
        if (this.mState != State.STOPPED) {
            throw new IllegalStateException("threadPriority only configurable before SerialInputOutputManager is started");
        }
        this.mThreadPriority = threadPriority;
    }

    public void setReadTimeout(int timeout) {
        if (this.mReadTimeout == 0 && timeout != 0 && this.mState != State.STOPPED) {
            throw new IllegalStateException("readTimeout only configurable before SerialInputOutputManager is started");
        }
        this.mReadTimeout = timeout;
    }

    public int getReadTimeout() {
        return this.mReadTimeout;
    }

    public void setWriteTimeout(int timeout) {
        this.mWriteTimeout = timeout;
    }

    public int getWriteTimeout() {
        return this.mWriteTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadBufferSize(int bufferSize) {
        if (this.getReadBufferSize() == bufferSize) {
            return;
        }
        Object object = this.mReadBufferLock;
        synchronized (object) {
            this.mReadBuffer = ByteBuffer.allocate(bufferSize);
        }
    }

    public int getReadBufferSize() {
        return this.mReadBuffer.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteBufferSize(int bufferSize) {
        if (this.getWriteBufferSize() == bufferSize) {
            return;
        }
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            ByteBuffer newWriteBuffer = ByteBuffer.allocate(bufferSize);
            if (this.mWriteBuffer.position() > 0) {
                newWriteBuffer.put(this.mWriteBuffer.array(), 0, this.mWriteBuffer.position());
            }
            this.mWriteBuffer = newWriteBuffer;
        }
    }

    public int getWriteBufferSize() {
        return this.mWriteBuffer.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsync(byte[] data) {
        Object object = this.mWriteBufferLock;
        synchronized (object) {
            this.mWriteBuffer.put(data);
        }
    }

    public void start() {
        if (this.mState != State.STOPPED) {
            throw new IllegalStateException("already started");
        }
        new Thread((Runnable)this, this.getClass().getSimpleName()).start();
    }

    public synchronized void stop() {
        if (this.getState() == State.RUNNING) {
            Log.i((String)TAG, (String)"Stop requested");
            this.mState = State.STOPPING;
        }
    }

    public synchronized State getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SerialInputOutputManager serialInputOutputManager = this;
        synchronized (serialInputOutputManager) {
            if (this.getState() != State.STOPPED) {
                throw new IllegalStateException("Already running");
            }
            this.mState = State.RUNNING;
        }
        Log.i((String)TAG, (String)"Running ...");
        try {
            if (this.mThreadPriority != 0) {
                Process.setThreadPriority((int)this.mThreadPriority);
            }
            while (true) {
                if (this.getState() != State.RUNNING) {
                    Log.i((String)TAG, (String)("Stopping mState=" + (Object)((Object)this.getState())));
                    break;
                }
                this.step();
            }
        }
        catch (Exception e) {
            if (this.mSerialPort.isOpen()) {
                Log.w((String)TAG, (String)("Run ending due to exception: " + e.getMessage()), (Throwable)e);
            } else {
                Log.i((String)TAG, (String)"Socket closed");
            }
            Listener listener = this.getListener();
            if (listener != null) {
                listener.onRunError(e);
            }
        }
        finally {
            SerialInputOutputManager serialInputOutputManager2 = this;
            synchronized (serialInputOutputManager2) {
                this.mState = State.STOPPED;
                Log.i((String)TAG, (String)"Stopped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step() throws IOException {
        Object listener;
        byte[] buffer;
        Object object = this.mReadBufferLock;
        synchronized (object) {
            buffer = this.mReadBuffer.array();
        }
        int len = this.mSerialPort.read(buffer, this.mReadTimeout);
        if (len > 0) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("Read data len=" + len));
            }
            if ((listener = this.getListener()) != null) {
                byte[] data = new byte[len];
                System.arraycopy(buffer, 0, data, 0, len);
                listener.onNewData(data);
            }
        }
        buffer = null;
        listener = this.mWriteBufferLock;
        synchronized (listener) {
            len = this.mWriteBuffer.position();
            if (len > 0) {
                buffer = new byte[len];
                this.mWriteBuffer.rewind();
                this.mWriteBuffer.get(buffer, 0, len);
                this.mWriteBuffer.clear();
            }
        }
        if (buffer != null) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("Writing data len=" + len));
            }
            try {
                this.mSerialPort.write(buffer, this.mWriteTimeout);
            }
            catch (SerialTimeoutException ex) {
                Object object2 = this.mWriteBufferLock;
                synchronized (object2) {
                    byte[] buffer2 = null;
                    int len2 = this.mWriteBuffer.position();
                    if (len2 > 0) {
                        buffer2 = new byte[len2];
                        this.mWriteBuffer.rewind();
                        this.mWriteBuffer.get(buffer2, 0, len2);
                        this.mWriteBuffer.clear();
                    }
                    this.mWriteBuffer.put(buffer, ex.bytesTransferred, buffer.length - ex.bytesTransferred);
                    if (buffer2 != null) {
                        this.mWriteBuffer.put(buffer2);
                    }
                }
            }
        }
    }

    public static enum State {
        STOPPED,
        RUNNING,
        STOPPING;

    }

    public static interface Listener {
        public void onNewData(byte[] var1);

        public void onRunError(Exception var1);
    }
}

