/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import com.hoho.android.usbserial.util.MonotonicClock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FtdiSerialDriver
implements UsbSerialDriver {
    private static final String TAG = FtdiSerialPort.class.getSimpleName();
    private final UsbDevice mDevice;
    private final List<UsbSerialPort> mPorts;

    public FtdiSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPorts = new ArrayList<UsbSerialPort>();
        for (int port = 0; port < device.getInterfaceCount(); ++port) {
            this.mPorts.add(new FtdiSerialPort(this.mDevice, port));
        }
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return this.mPorts;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(1027, new int[]{24577, 24596, 24592, 24593, 24597});
        return supportedDevices;
    }

    public class FtdiSerialPort
    extends CommonUsbSerialPort {
        private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
        private static final int READ_HEADER_LENGTH = 2;
        private static final int REQTYPE_HOST_TO_DEVICE = 64;
        private static final int REQTYPE_DEVICE_TO_HOST = 192;
        private static final int RESET_REQUEST = 0;
        private static final int MODEM_CONTROL_REQUEST = 1;
        private static final int SET_BAUD_RATE_REQUEST = 3;
        private static final int SET_DATA_REQUEST = 4;
        private static final int GET_MODEM_STATUS_REQUEST = 5;
        private static final int SET_LATENCY_TIMER_REQUEST = 9;
        private static final int GET_LATENCY_TIMER_REQUEST = 10;
        private static final int MODEM_CONTROL_DTR_ENABLE = 257;
        private static final int MODEM_CONTROL_DTR_DISABLE = 256;
        private static final int MODEM_CONTROL_RTS_ENABLE = 514;
        private static final int MODEM_CONTROL_RTS_DISABLE = 512;
        private static final int MODEM_STATUS_CTS = 16;
        private static final int MODEM_STATUS_DSR = 32;
        private static final int MODEM_STATUS_RI = 64;
        private static final int MODEM_STATUS_CD = 128;
        private static final int RESET_ALL = 0;
        private static final int RESET_PURGE_RX = 1;
        private static final int RESET_PURGE_TX = 2;
        private boolean baudRateWithPort;
        private boolean dtr;
        private boolean rts;
        private int breakConfig;

        public FtdiSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.baudRateWithPort = false;
            this.dtr = false;
            this.rts = false;
            this.breakConfig = 0;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return FtdiSerialDriver.this;
        }

        @Override
        protected void openInt(UsbDeviceConnection connection) throws IOException {
            if (!connection.claimInterface(this.mDevice.getInterface(this.mPortNumber), true)) {
                throw new IOException("Could not claim interface " + this.mPortNumber);
            }
            if (this.mDevice.getInterface(this.mPortNumber).getEndpointCount() < 2) {
                throw new IOException("Not enough endpoints");
            }
            this.mReadEndpoint = this.mDevice.getInterface(this.mPortNumber).getEndpoint(0);
            this.mWriteEndpoint = this.mDevice.getInterface(this.mPortNumber).getEndpoint(1);
            int result = this.mConnection.controlTransfer(64, 0, 0, this.mPortNumber + 1, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Reset failed: result=" + result);
            }
            result = this.mConnection.controlTransfer(64, 1, (this.dtr ? 257 : 256) | (this.rts ? 514 : 512), this.mPortNumber + 1, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Init RTS,DTR failed: result=" + result);
            }
            byte[] rawDescriptors = connection.getRawDescriptors();
            if (rawDescriptors == null || rawDescriptors.length < 14) {
                throw new IOException("Could not get device descriptors");
            }
            byte deviceType = rawDescriptors[13];
            this.baudRateWithPort = deviceType == 7 || deviceType == 8 || deviceType == 9 || this.mDevice.getInterfaceCount() > 1;
        }

        @Override
        protected void closeInt() {
            try {
                this.mConnection.releaseInterface(this.mDevice.getInterface(this.mPortNumber));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public int read(byte[] dest, int timeout) throws IOException {
            int nread;
            if (dest.length <= 2) {
                throw new IllegalArgumentException("Read buffer to small");
            }
            if (timeout != 0) {
                long endTime = MonotonicClock.millis() + (long)timeout;
                while ((nread = super.read(dest, Math.max(1, (int)(endTime - MonotonicClock.millis())), false)) == 2 && MonotonicClock.millis() < endTime) {
                }
                if (nread <= 0 && MonotonicClock.millis() < endTime) {
                    this.testConnection();
                }
            } else {
                while ((nread = super.read(dest, timeout, false)) == 2) {
                }
            }
            return this.readFilter(dest, nread);
        }

        protected int readFilter(byte[] buffer, int totalBytesRead) throws IOException {
            int maxPacketSize = this.mReadEndpoint.getMaxPacketSize();
            int destPos = 0;
            for (int srcPos = 0; srcPos < totalBytesRead; srcPos += maxPacketSize) {
                int length = Math.min(srcPos + maxPacketSize, totalBytesRead) - (srcPos + 2);
                if (length < 0) {
                    throw new IOException("Expected at least 2 bytes");
                }
                System.arraycopy(buffer, srcPos + 2, buffer, destPos, length);
                destPos += length;
            }
            return destPos;
        }

        private void setBaudrate(int baudRate) throws IOException {
            int effectiveBaudRate;
            int subdivisor;
            int divisor;
            if (baudRate > 3500000) {
                throw new UnsupportedOperationException("Baud rate to high");
            }
            if (baudRate >= 2500000) {
                divisor = 0;
                subdivisor = 0;
                effectiveBaudRate = 3000000;
            } else if (baudRate >= 1750000) {
                divisor = 1;
                subdivisor = 0;
                effectiveBaudRate = 2000000;
            } else {
                divisor = 48000000 / baudRate;
                divisor = divisor + 1 >> 1;
                subdivisor = divisor & 7;
                if ((divisor >>= 3) > 16383) {
                    throw new UnsupportedOperationException("Baud rate to low");
                }
                effectiveBaudRate = 48000000 / ((divisor << 3) + subdivisor);
                effectiveBaudRate = effectiveBaudRate + 1 >> 1;
            }
            double baudRateError = Math.abs(1.0 - (double)effectiveBaudRate / (double)baudRate);
            if (baudRateError >= 0.031) {
                throw new UnsupportedOperationException(String.format("Baud rate deviation %.1f%% is higher than allowed 3%%", baudRateError * 100.0));
            }
            int value = divisor;
            int index = 0;
            switch (subdivisor) {
                case 0: {
                    break;
                }
                case 4: {
                    value |= 0x4000;
                    break;
                }
                case 2: {
                    value |= 0x8000;
                    break;
                }
                case 1: {
                    value |= 0xC000;
                    break;
                }
                case 3: {
                    value |= 0;
                    index |= 1;
                    break;
                }
                case 5: {
                    value |= 0x4000;
                    index |= 1;
                    break;
                }
                case 6: {
                    value |= 0x8000;
                    index |= 1;
                    break;
                }
                case 7: {
                    value |= 0xC000;
                    index |= 1;
                }
            }
            if (this.baudRateWithPort) {
                index <<= 8;
                index |= this.mPortNumber + 1;
            }
            Log.d((String)TAG, (String)String.format("baud rate=%d, effective=%d, error=%.1f%%, value=0x%04x, index=0x%04x, divisor=%d, subdivisor=%d", baudRate, effectiveBaudRate, baudRateError * 100.0, value, index, divisor, subdivisor));
            int result = this.mConnection.controlTransfer(64, 3, value, index, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Setting baudrate failed: result=" + result);
            }
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            this.setBaudrate(baudRate);
            int config = 0;
            switch (dataBits) {
                case 5: 
                case 6: {
                    throw new UnsupportedOperationException("Unsupported data bits: " + dataBits);
                }
                case 7: 
                case 8: {
                    config |= dataBits;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data bits: " + dataBits);
                }
            }
            switch (parity) {
                case 0: {
                    break;
                }
                case 1: {
                    config |= 0x100;
                    break;
                }
                case 2: {
                    config |= 0x200;
                    break;
                }
                case 3: {
                    config |= 0x300;
                    break;
                }
                case 4: {
                    config |= 0x400;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            switch (stopBits) {
                case 1: {
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("Unsupported stop bits: 1.5");
                }
                case 2: {
                    config |= 0x1000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            int result = this.mConnection.controlTransfer(64, 4, config, this.mPortNumber + 1, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Setting parameters failed: result=" + result);
            }
            this.breakConfig = config;
        }

        private int getStatus() throws IOException {
            byte[] data = new byte[2];
            int result = this.mConnection.controlTransfer(192, 5, 0, this.mPortNumber + 1, data, data.length, 5000);
            if (result != 2) {
                throw new IOException("Get modem status failed: result=" + result);
            }
            return data[0];
        }

        @Override
        public boolean getCD() throws IOException {
            return (this.getStatus() & 0x80) != 0;
        }

        @Override
        public boolean getCTS() throws IOException {
            return (this.getStatus() & 0x10) != 0;
        }

        @Override
        public boolean getDSR() throws IOException {
            return (this.getStatus() & 0x20) != 0;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.dtr;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            int result = this.mConnection.controlTransfer(64, 1, value ? 257 : 256, this.mPortNumber + 1, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Set DTR failed: result=" + result);
            }
            this.dtr = value;
        }

        @Override
        public boolean getRI() throws IOException {
            return (this.getStatus() & 0x40) != 0;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.rts;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            int result = this.mConnection.controlTransfer(64, 1, value ? 514 : 512, this.mPortNumber + 1, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Set DTR failed: result=" + result);
            }
            this.rts = value;
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getControlLines() throws IOException {
            int status = this.getStatus();
            EnumSet<UsbSerialPort.ControlLine> set = EnumSet.noneOf(UsbSerialPort.ControlLine.class);
            if (this.rts) {
                set.add(UsbSerialPort.ControlLine.RTS);
            }
            if ((status & 0x10) != 0) {
                set.add(UsbSerialPort.ControlLine.CTS);
            }
            if (this.dtr) {
                set.add(UsbSerialPort.ControlLine.DTR);
            }
            if ((status & 0x20) != 0) {
                set.add(UsbSerialPort.ControlLine.DSR);
            }
            if ((status & 0x80) != 0) {
                set.add(UsbSerialPort.ControlLine.CD);
            }
            if ((status & 0x40) != 0) {
                set.add(UsbSerialPort.ControlLine.RI);
            }
            return set;
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException {
            return EnumSet.allOf(UsbSerialPort.ControlLine.class);
        }

        @Override
        public void purgeHwBuffers(boolean purgeWriteBuffers, boolean purgeReadBuffers) throws IOException {
            int result;
            if (purgeWriteBuffers && (result = this.mConnection.controlTransfer(64, 0, 1, this.mPortNumber + 1, null, 0, 5000)) != 0) {
                throw new IOException("Purge write buffer failed: result=" + result);
            }
            if (purgeReadBuffers && (result = this.mConnection.controlTransfer(64, 0, 2, this.mPortNumber + 1, null, 0, 5000)) != 0) {
                throw new IOException("Purge read buffer failed: result=" + result);
            }
        }

        @Override
        public void setBreak(boolean value) throws IOException {
            int result;
            int config = this.breakConfig;
            if (value) {
                config |= 0x4000;
            }
            if ((result = this.mConnection.controlTransfer(64, 4, config, this.mPortNumber + 1, null, 0, 5000)) != 0) {
                throw new IOException("Setting BREAK failed: result=" + result);
            }
        }

        public void setLatencyTimer(int latencyTime) throws IOException {
            int result = this.mConnection.controlTransfer(64, 9, latencyTime, this.mPortNumber + 1, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Set latency timer failed: result=" + result);
            }
        }

        public int getLatencyTimer() throws IOException {
            byte[] data = new byte[1];
            int result = this.mConnection.controlTransfer(192, 10, 0, this.mPortNumber + 1, data, data.length, 5000);
            if (result != 1) {
                throw new IOException("Get latency timer failed: result=" + result);
            }
            return data[0];
        }
    }
}

