/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;

public interface UsbSerialPort
extends Closeable {
    public static final int DATABITS_5 = 5;
    public static final int DATABITS_6 = 6;
    public static final int DATABITS_7 = 7;
    public static final int DATABITS_8 = 8;
    public static final int FLOWCONTROL_NONE = 0;
    public static final int FLOWCONTROL_RTSCTS_IN = 1;
    public static final int FLOWCONTROL_RTSCTS_OUT = 2;
    public static final int FLOWCONTROL_XONXOFF_IN = 4;
    public static final int FLOWCONTROL_XONXOFF_OUT = 8;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    public static final int STOPBITS_1 = 1;
    public static final int STOPBITS_1_5 = 3;
    public static final int STOPBITS_2 = 2;

    public UsbSerialDriver getDriver();

    public UsbDevice getDevice();

    public int getPortNumber();

    public String getSerial();

    public void open(UsbDeviceConnection var1) throws IOException;

    @Override
    public void close() throws IOException;

    public int read(byte[] var1, int var2) throws IOException;

    public int write(byte[] var1, int var2) throws IOException;

    public void setParameters(int var1, int var2, int var3, int var4) throws IOException;

    public boolean getCD() throws IOException;

    public boolean getCTS() throws IOException;

    public boolean getDSR() throws IOException;

    public boolean getDTR() throws IOException;

    public void setDTR(boolean var1) throws IOException;

    public boolean getRI() throws IOException;

    public boolean getRTS() throws IOException;

    public void setRTS(boolean var1) throws IOException;

    public EnumSet<ControlLine> getControlLines() throws IOException;

    public EnumSet<ControlLine> getSupportedControlLines() throws IOException;

    public boolean purgeHwBuffers(boolean var1, boolean var2) throws IOException;

    public boolean isOpen();

    public static enum ControlLine {
        RTS,
        CTS,
        DTR,
        DSR,
        CD,
        RI;

    }
}

