/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FtdiSerialDriver
implements UsbSerialDriver {
    private final UsbDevice mDevice;
    private final List<UsbSerialPort> mPorts;

    public FtdiSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPorts = new ArrayList<UsbSerialPort>();
        for (int port = 0; port < device.getInterfaceCount(); ++port) {
            this.mPorts.add(new FtdiSerialPort(this.mDevice, port));
        }
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return this.mPorts;
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(1027, new int[]{24577, 24596, 24592, 24593, 24597});
        return supportedDevices;
    }

    public class FtdiSerialPort
    extends CommonUsbSerialPort {
        private static final int USB_TYPE_STANDARD = 0;
        private static final int USB_TYPE_CLASS = 0;
        private static final int USB_TYPE_VENDOR = 0;
        private static final int USB_TYPE_RESERVED = 0;
        private static final int USB_RECIP_DEVICE = 0;
        private static final int USB_RECIP_INTERFACE = 1;
        private static final int USB_RECIP_ENDPOINT = 2;
        private static final int USB_RECIP_OTHER = 3;
        private static final int USB_ENDPOINT_IN = 128;
        private static final int USB_ENDPOINT_OUT = 0;
        private static final int USB_WRITE_TIMEOUT_MILLIS = 5000;
        private static final int USB_READ_TIMEOUT_MILLIS = 5000;
        private static final int SIO_RESET_REQUEST = 0;
        private static final int SIO_MODEM_CTRL_REQUEST = 1;
        private static final int SIO_SET_FLOW_CTRL_REQUEST = 2;
        private static final int SIO_SET_DTR_HIGH = 257;
        private static final int SIO_SET_DTR_LOW = 256;
        private static final int SIO_SET_RTS_HIGH = 514;
        private static final int SIO_SET_RTS_LOW = 512;
        private static final int SIO_SET_BAUD_RATE_REQUEST = 3;
        private static final int SIO_SET_DATA_REQUEST = 4;
        private static final int SIO_RESET_SIO = 0;
        private static final int SIO_RESET_PURGE_RX = 1;
        private static final int SIO_RESET_PURGE_TX = 2;
        private static final int SIO_GET_MODEM_STATUS_REQUEST = 5;
        private static final int SIO_MODEM_STATUS_CTS = 16;
        private static final int SIO_MODEM_STATUS_DSR = 32;
        private static final int SIO_MODEM_STATUS_RI = 64;
        private static final int SIO_MODEM_STATUS_RLSD = 128;
        private static final int SIO_SET_LATENCY_TIMER_REQUEST = 9;
        private static final int SIO_GET_LATENCY_TIMER_REQUEST = 10;
        private static final int FTDI_DEVICE_OUT_REQTYPE = 64;
        private static final int FTDI_DEVICE_IN_REQTYPE = 192;
        private static final int MODEM_STATUS_HEADER_LENGTH = 2;
        private final String TAG;
        private DeviceType mType;
        private int mIndex;
        private boolean mDtrState;
        private boolean mRtsState;

        public FtdiSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.TAG = FtdiSerialDriver.class.getSimpleName();
            this.mIndex = 0;
            this.mDtrState = false;
            this.mRtsState = false;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return FtdiSerialDriver.this;
        }

        @Override
        protected int readFilter(byte[] buffer, int totalBytesRead) throws IOException {
            if (totalBytesRead < 2) {
                throw new IOException("Expected at least 2 bytes");
            }
            int maxPacketSize = this.mReadEndpoint.getMaxPacketSize();
            int packetsCount = (totalBytesRead + maxPacketSize - 1) / maxPacketSize;
            for (int packetIdx = 0; packetIdx < packetsCount; ++packetIdx) {
                int count;
                int n = count = packetIdx == packetsCount - 1 ? totalBytesRead - packetIdx * maxPacketSize - 2 : maxPacketSize - 2;
                if (count <= 0) continue;
                System.arraycopy(buffer, packetIdx * maxPacketSize + 2, buffer, packetIdx * (maxPacketSize - 2), count);
            }
            return totalBytesRead - packetsCount * 2;
        }

        private void reset() throws IOException {
            int result;
            this.mType = DeviceType.TYPE_R;
            if (this.mDevice.getInterfaceCount() > 1) {
                this.mIndex = this.mPortNumber + 1;
                if (this.mDevice.getInterfaceCount() == 2) {
                    this.mType = DeviceType.TYPE_2232H;
                }
                if (this.mDevice.getInterfaceCount() == 4) {
                    this.mType = DeviceType.TYPE_4232H;
                }
            }
            if ((result = this.mConnection.controlTransfer(64, 0, 0, this.mIndex, null, 0, 5000)) != 0) {
                throw new IOException("Reset failed: result=" + result);
            }
            this.mDtrState = false;
            this.mRtsState = false;
        }

        public void setLatencyTimer(int latencyTime) throws IOException {
            int result = this.mConnection.controlTransfer(64, 9, latencyTime, this.mIndex, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Set latency timer failed: result=" + result);
            }
        }

        public int getLatencyTimer() throws IOException {
            byte[] data = new byte[1];
            int result = this.mConnection.controlTransfer(192, 10, 0, this.mIndex, data, data.length, 5000);
            if (result != 1) {
                throw new IOException("Get latency timer failed: result=" + result);
            }
            return data[0];
        }

        private int getModemStatus() throws IOException {
            byte[] data = new byte[2];
            int result = this.mConnection.controlTransfer(192, 5, 0, this.mIndex, data, data.length, 5000);
            if (result != 2) {
                throw new IOException("Get modem statusfailed: result=" + result);
            }
            return data[0];
        }

        @Override
        protected void openInt(UsbDeviceConnection connection) throws IOException {
            if (!connection.claimInterface(this.mDevice.getInterface(this.mPortNumber), true)) {
                throw new IOException("Error claiming interface " + this.mPortNumber);
            }
            Log.d((String)this.TAG, (String)("claimInterface " + this.mPortNumber + " SUCCESS"));
            if (this.mDevice.getInterface(this.mPortNumber).getEndpointCount() < 2) {
                throw new IOException("Insufficient number of endpoints (" + this.mDevice.getInterface(this.mPortNumber).getEndpointCount() + ")");
            }
            this.mReadEndpoint = this.mDevice.getInterface(this.mPortNumber).getEndpoint(0);
            this.mWriteEndpoint = this.mDevice.getInterface(this.mPortNumber).getEndpoint(1);
            this.reset();
        }

        @Override
        protected void closeInt() {
            try {
                this.mConnection.releaseInterface(this.mDevice.getInterface(this.mPortNumber));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int setBaudRate(int baudRate) throws IOException {
            long[] vals = this.convertBaudrate(baudRate);
            long actualBaudrate = vals[0];
            long value = vals[2];
            long index = vals[1];
            int result = this.mConnection.controlTransfer(64, 3, (int)value, (int)index, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Setting baudrate failed: result=" + result);
            }
            return (int)actualBaudrate;
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            if (baudRate <= 0) {
                throw new IllegalArgumentException("Invalid baud rate: " + baudRate);
            }
            this.setBaudRate(baudRate);
            int config = 0;
            switch (dataBits) {
                case 5: 
                case 6: {
                    throw new UnsupportedOperationException("Unsupported data bits: " + dataBits);
                }
                case 7: 
                case 8: {
                    config |= dataBits;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid data bits: " + dataBits);
                }
            }
            switch (parity) {
                case 0: {
                    config |= 0;
                    break;
                }
                case 1: {
                    config |= 0x100;
                    break;
                }
                case 2: {
                    config |= 0x200;
                    break;
                }
                case 3: {
                    config |= 0x300;
                    break;
                }
                case 4: {
                    config |= 0x400;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid parity: " + parity);
                }
            }
            switch (stopBits) {
                case 1: {
                    config |= 0;
                    break;
                }
                case 3: {
                    throw new UnsupportedOperationException("Unsupported stop bits: 1.5");
                }
                case 2: {
                    config |= 0x1000;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid stop bits: " + stopBits);
                }
            }
            int result = this.mConnection.controlTransfer(64, 4, config, this.mIndex, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Setting parameters failed: result=" + result);
            }
        }

        private long[] convertBaudrate(int baudrate) {
            long index;
            long encodedDivisor;
            int divisor = 24000000 / baudrate;
            int bestDivisor = 0;
            int bestBaud = 0;
            int bestBaudDiff = 0;
            int[] fracCode = new int[]{0, 3, 2, 4, 1, 5, 6, 7};
            for (int i = 0; i < 2; ++i) {
                int tryDivisor = divisor + i;
                if (tryDivisor <= 8) {
                    tryDivisor = 8;
                } else if (this.mType != DeviceType.TYPE_AM && tryDivisor < 12) {
                    tryDivisor = 12;
                } else if (divisor < 16) {
                    tryDivisor = 16;
                } else if (this.mType != DeviceType.TYPE_AM && tryDivisor > 131071) {
                    tryDivisor = 131071;
                }
                int baudEstimate = (24000000 + tryDivisor / 2) / tryDivisor;
                int baudDiff = baudEstimate < baudrate ? baudrate - baudEstimate : baudEstimate - baudrate;
                if (i != 0 && baudDiff >= bestBaudDiff) continue;
                bestDivisor = tryDivisor;
                bestBaud = baudEstimate;
                bestBaudDiff = baudDiff;
                if (baudDiff == 0) break;
            }
            if ((encodedDivisor = (long)(bestDivisor >> 3 | fracCode[bestDivisor & 7] << 14)) == 1L) {
                encodedDivisor = 0L;
            } else if (encodedDivisor == 16385L) {
                encodedDivisor = 1L;
            }
            long value = encodedDivisor & 0xFFFFL;
            if (this.mType == DeviceType.TYPE_2232C || this.mType == DeviceType.TYPE_2232H || this.mType == DeviceType.TYPE_4232H) {
                index = encodedDivisor >> 8 & 0xFF00L;
                index |= (long)this.mIndex;
            } else {
                index = encodedDivisor >> 16 & 0xFFFFL;
            }
            return new long[]{bestBaud, index, value};
        }

        @Override
        public boolean getCD() throws IOException {
            return (this.getModemStatus() & 0x80) != 0;
        }

        @Override
        public boolean getCTS() throws IOException {
            return (this.getModemStatus() & 0x10) != 0;
        }

        @Override
        public boolean getDSR() throws IOException {
            return (this.getModemStatus() & 0x20) != 0;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.mDtrState;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            int result = this.mConnection.controlTransfer(64, 1, value ? 257 : 256, this.mIndex, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Set DTR failed: result=" + result);
            }
            this.mDtrState = value;
        }

        @Override
        public boolean getRI() throws IOException {
            return (this.getModemStatus() & 0x40) != 0;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.mRtsState;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            int result = this.mConnection.controlTransfer(64, 1, value ? 514 : 512, this.mIndex, null, 0, 5000);
            if (result != 0) {
                throw new IOException("Set DTR failed: result=" + result);
            }
            this.mRtsState = value;
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getControlLines() throws IOException {
            int status = this.getModemStatus();
            EnumSet<UsbSerialPort.ControlLine> set = EnumSet.noneOf(UsbSerialPort.ControlLine.class);
            if (this.mRtsState) {
                set.add(UsbSerialPort.ControlLine.RTS);
            }
            if ((status & 0x10) != 0) {
                set.add(UsbSerialPort.ControlLine.CTS);
            }
            if (this.mDtrState) {
                set.add(UsbSerialPort.ControlLine.DTR);
            }
            if ((status & 0x20) != 0) {
                set.add(UsbSerialPort.ControlLine.DSR);
            }
            if ((status & 0x80) != 0) {
                set.add(UsbSerialPort.ControlLine.CD);
            }
            if ((status & 0x40) != 0) {
                set.add(UsbSerialPort.ControlLine.RI);
            }
            return set;
        }

        @Override
        public EnumSet<UsbSerialPort.ControlLine> getSupportedControlLines() throws IOException {
            return EnumSet.allOf(UsbSerialPort.ControlLine.class);
        }

        @Override
        public boolean purgeHwBuffers(boolean purgeWriteBuffers, boolean purgeReadBuffers) throws IOException {
            int result;
            if (purgeWriteBuffers && (result = this.mConnection.controlTransfer(64, 0, 1, this.mIndex, null, 0, 5000)) != 0) {
                throw new IOException("purge write buffer failed: result=" + result);
            }
            if (purgeReadBuffers && (result = this.mConnection.controlTransfer(64, 0, 2, this.mIndex, null, 0, 5000)) != 0) {
                throw new IOException("purge read buffer failed: result=" + result);
            }
            return true;
        }
    }

    private static enum DeviceType {
        TYPE_BM,
        TYPE_AM,
        TYPE_2232C,
        TYPE_R,
        TYPE_2232H,
        TYPE_4232H;

    }
}

