/*
 * Decompiled with CFR 0.152.
 */
package com.hoho.android.usbserial.driver;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbRequest;
import android.util.Log;
import com.hoho.android.usbserial.driver.CommonUsbSerialPort;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialPort;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CdcAcmSerialDriver
implements UsbSerialDriver {
    private final String TAG = CdcAcmSerialDriver.class.getSimpleName();
    private final UsbDevice mDevice;
    private final UsbSerialPort mPort;

    public CdcAcmSerialDriver(UsbDevice device) {
        this.mDevice = device;
        this.mPort = new CdcAcmSerialPort(device, 0);
    }

    @Override
    public UsbDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public List<UsbSerialPort> getPorts() {
        return Collections.singletonList(this.mPort);
    }

    public static Map<Integer, int[]> getSupportedDevices() {
        LinkedHashMap<Integer, int[]> supportedDevices = new LinkedHashMap<Integer, int[]>();
        supportedDevices.put(9025, new int[]{1, 67, 16, 66, 59, 68, 63, 68, 32822, 32823});
        supportedDevices.put(5824, new int[]{1155});
        supportedDevices.put(1003, new int[]{8260});
        supportedDevices.put(7855, new int[]{4});
        supportedDevices.put(3368, new int[]{516});
        return supportedDevices;
    }

    class CdcAcmSerialPort
    extends CommonUsbSerialPort {
        private UsbInterface mControlInterface;
        private UsbInterface mDataInterface;
        private UsbEndpoint mControlEndpoint;
        private UsbEndpoint mReadEndpoint;
        private UsbEndpoint mWriteEndpoint;
        private int mControlIndex;
        private boolean mRts;
        private boolean mDtr;
        private static final int USB_RECIP_INTERFACE = 1;
        private static final int USB_RT_ACM = 33;
        private static final int SET_LINE_CODING = 32;
        private static final int GET_LINE_CODING = 33;
        private static final int SET_CONTROL_LINE_STATE = 34;
        private static final int SEND_BREAK = 35;

        public CdcAcmSerialPort(UsbDevice device, int portNumber) {
            super(device, portNumber);
            this.mRts = false;
            this.mDtr = false;
        }

        @Override
        public UsbSerialDriver getDriver() {
            return CdcAcmSerialDriver.this;
        }

        @Override
        public void open(UsbDeviceConnection connection) throws IOException {
            if (this.mConnection != null) {
                throw new IOException("Already open");
            }
            this.mConnection = connection;
            boolean opened = false;
            try {
                if (1 == this.mDevice.getInterfaceCount()) {
                    Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"device might be castrated ACM device, trying single interface logic");
                    this.openSingleInterface();
                } else {
                    Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"trying default interface logic");
                    this.openInterface();
                }
                opened = true;
            }
            finally {
                if (!opened) {
                    this.mConnection = null;
                    this.mControlEndpoint = null;
                    this.mReadEndpoint = null;
                    this.mWriteEndpoint = null;
                }
            }
        }

        private void openSingleInterface() throws IOException {
            this.mControlIndex = 0;
            this.mControlInterface = this.mDevice.getInterface(0);
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("Control iface=" + this.mControlInterface));
            this.mDataInterface = this.mDevice.getInterface(0);
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("data iface=" + this.mDataInterface));
            if (!this.mConnection.claimInterface(this.mControlInterface, true)) {
                throw new IOException("Could not claim shared control/data interface.");
            }
            int endCount = this.mControlInterface.getEndpointCount();
            if (endCount < 3) {
                Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("not enough endpoints - need 3. count=" + this.mControlInterface.getEndpointCount()));
                throw new IOException("Insufficient number of endpoints(" + this.mControlInterface.getEndpointCount() + ")");
            }
            this.mControlEndpoint = null;
            this.mReadEndpoint = null;
            this.mWriteEndpoint = null;
            for (int i = 0; i < endCount; ++i) {
                UsbEndpoint ep = this.mControlInterface.getEndpoint(i);
                if (ep.getDirection() == 128 && ep.getType() == 3) {
                    Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"Found controlling endpoint");
                    this.mControlEndpoint = ep;
                } else if (ep.getDirection() == 128 && ep.getType() == 2) {
                    Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"Found reading endpoint");
                    this.mReadEndpoint = ep;
                } else if (ep.getDirection() == 0 && ep.getType() == 2) {
                    Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"Found writing endpoint");
                    this.mWriteEndpoint = ep;
                }
                if (this.mControlEndpoint == null || this.mReadEndpoint == null || this.mWriteEndpoint == null) continue;
                Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"Found all required endpoints");
                break;
            }
            if (this.mControlEndpoint == null || this.mReadEndpoint == null || this.mWriteEndpoint == null) {
                Log.d((String)CdcAcmSerialDriver.this.TAG, (String)"Could not establish all endpoints");
                throw new IOException("Could not establish all endpoints");
            }
        }

        private void openInterface() throws IOException {
            int i;
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("claiming interfaces, count=" + this.mDevice.getInterfaceCount()));
            this.mControlInterface = null;
            this.mDataInterface = null;
            for (i = 0; i < this.mDevice.getInterfaceCount(); ++i) {
                UsbInterface usbInterface = this.mDevice.getInterface(i);
                if (usbInterface.getInterfaceClass() == 2) {
                    this.mControlIndex = i;
                    this.mControlInterface = usbInterface;
                }
                if (usbInterface.getInterfaceClass() != 10) continue;
                this.mDataInterface = usbInterface;
            }
            if (this.mControlInterface == null) {
                throw new IOException("no control interface.");
            }
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("Control iface=" + this.mControlInterface));
            if (!this.mConnection.claimInterface(this.mControlInterface, true)) {
                throw new IOException("Could not claim control interface.");
            }
            this.mControlEndpoint = this.mControlInterface.getEndpoint(0);
            if (this.mControlEndpoint.getDirection() != 128 || this.mControlEndpoint.getType() != 3) {
                throw new IOException("invalid control endpoint");
            }
            if (this.mDataInterface == null) {
                throw new IOException("no data interface.");
            }
            Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("data iface=" + this.mDataInterface));
            if (!this.mConnection.claimInterface(this.mDataInterface, true)) {
                throw new IOException("Could not claim data interface.");
            }
            this.mReadEndpoint = null;
            this.mWriteEndpoint = null;
            for (i = 0; i < this.mDataInterface.getEndpointCount(); ++i) {
                UsbEndpoint ep = this.mDataInterface.getEndpoint(i);
                if (ep.getDirection() == 128 && ep.getType() == 2) {
                    this.mReadEndpoint = ep;
                }
                if (ep.getDirection() != 0 || ep.getType() != 2) continue;
                this.mWriteEndpoint = ep;
            }
            if (this.mReadEndpoint == null || this.mWriteEndpoint == null) {
                throw new IOException("Could not get read&write endpoints.");
            }
        }

        private int sendAcmControlMessage(int request, int value, byte[] buf) throws IOException {
            int len = this.mConnection.controlTransfer(33, request, value, this.mControlIndex, buf, buf != null ? buf.length : 0, 5000);
            if (len < 0) {
                throw new IOException("controlTransfer failed.");
            }
            return len;
        }

        @Override
        public void close() throws IOException {
            if (this.mConnection == null) {
                throw new IOException("Already closed");
            }
            this.mConnection.close();
            this.mConnection = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] dest, int timeoutMillis) throws IOException {
            try (UsbRequest request = new UsbRequest();){
                request.initialize(this.mConnection, this.mReadEndpoint);
                ByteBuffer buf = ByteBuffer.wrap(dest);
                if (!request.queue(buf, dest.length)) {
                    throw new IOException("Error queueing request.");
                }
                UsbRequest response = this.mConnection.requestWait();
                if (response == null) {
                    throw new IOException("Null response");
                }
                int nread = buf.position();
                if (nread > 0) {
                    int n = nread;
                    return n;
                }
                int n = 0;
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(byte[] src, int timeoutMillis) throws IOException {
            int offset;
            int amtWritten;
            for (offset = 0; offset < src.length; offset += amtWritten) {
                int writeLength;
                Object object = this.mWriteBufferLock;
                synchronized (object) {
                    byte[] writeBuffer;
                    writeLength = Math.min(src.length - offset, this.mWriteBuffer.length);
                    if (offset == 0) {
                        writeBuffer = src;
                    } else {
                        System.arraycopy(src, offset, this.mWriteBuffer, 0, writeLength);
                        writeBuffer = this.mWriteBuffer;
                    }
                    amtWritten = this.mConnection.bulkTransfer(this.mWriteEndpoint, writeBuffer, writeLength, timeoutMillis);
                }
                if (amtWritten <= 0) {
                    throw new IOException("Error writing " + writeLength + " bytes at offset " + offset + " length=" + src.length);
                }
                Log.d((String)CdcAcmSerialDriver.this.TAG, (String)("Wrote amt=" + amtWritten + " attempted=" + writeLength));
            }
            return offset;
        }

        @Override
        public void setParameters(int baudRate, int dataBits, int stopBits, int parity) throws IOException {
            byte parityBitesByte;
            byte stopBitsByte;
            switch (stopBits) {
                case 1: {
                    stopBitsByte = 0;
                    break;
                }
                case 3: {
                    stopBitsByte = 1;
                    break;
                }
                case 2: {
                    stopBitsByte = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad value for stopBits: " + stopBits);
                }
            }
            switch (parity) {
                case 0: {
                    parityBitesByte = 0;
                    break;
                }
                case 1: {
                    parityBitesByte = 1;
                    break;
                }
                case 2: {
                    parityBitesByte = 2;
                    break;
                }
                case 3: {
                    parityBitesByte = 3;
                    break;
                }
                case 4: {
                    parityBitesByte = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad value for parity: " + parity);
                }
            }
            byte[] msg = new byte[]{(byte)(baudRate & 0xFF), (byte)(baudRate >> 8 & 0xFF), (byte)(baudRate >> 16 & 0xFF), (byte)(baudRate >> 24 & 0xFF), stopBitsByte, parityBitesByte, (byte)dataBits};
            this.sendAcmControlMessage(32, 0, msg);
        }

        @Override
        public boolean getCD() throws IOException {
            return false;
        }

        @Override
        public boolean getCTS() throws IOException {
            return false;
        }

        @Override
        public boolean getDSR() throws IOException {
            return false;
        }

        @Override
        public boolean getDTR() throws IOException {
            return this.mDtr;
        }

        @Override
        public void setDTR(boolean value) throws IOException {
            this.mDtr = value;
            this.setDtrRts();
        }

        @Override
        public boolean getRI() throws IOException {
            return false;
        }

        @Override
        public boolean getRTS() throws IOException {
            return this.mRts;
        }

        @Override
        public void setRTS(boolean value) throws IOException {
            this.mRts = value;
            this.setDtrRts();
        }

        private void setDtrRts() throws IOException {
            int value = (this.mRts ? 2 : 0) | (this.mDtr ? 1 : 0);
            this.sendAcmControlMessage(34, value, null);
        }
    }
}

