/*
 * Decompiled with CFR 0.152.
 */
package com.mynameismidori.currencypicker;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.mynameismidori.currencypicker.CurrencyListAdapter;
import com.mynameismidori.currencypicker.CurrencyPickerListener;
import com.mynameismidori.currencypicker.ExtendedCurrency;
import com.mynameismidori.currencypicker.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class CurrencyPicker
extends DialogFragment {
    private EditText searchEditText;
    private ListView currencyListView;
    private CurrencyListAdapter adapter;
    private List<ExtendedCurrency> currenciesList = new ArrayList<ExtendedCurrency>();
    private List<ExtendedCurrency> selectedCurrenciesList = new ArrayList<ExtendedCurrency>();
    private CurrencyPickerListener listener;
    private Context context;

    public static CurrencyPicker newInstance(String dialogTitle) {
        CurrencyPicker picker = new CurrencyPicker();
        Bundle bundle = new Bundle();
        bundle.putString("dialogTitle", dialogTitle);
        picker.setArguments(bundle);
        return picker;
    }

    public CurrencyPicker() {
        this.setCurrenciesList(ExtendedCurrency.getAllCurrencies());
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.currency_picker, null);
        Bundle args = this.getArguments();
        if (args != null && this.getDialog() != null) {
            String dialogTitle = args.getString("dialogTitle");
            this.getDialog().setTitle((CharSequence)dialogTitle);
            int width = this.getResources().getDimensionPixelSize(R.dimen.cp_dialog_width);
            int height = this.getResources().getDimensionPixelSize(R.dimen.cp_dialog_height);
            this.getDialog().getWindow().setLayout(width, height);
        }
        this.searchEditText = (EditText)view.findViewById(R.id.currency_code_picker_search);
        this.currencyListView = (ListView)view.findViewById(R.id.currency_code_picker_listview);
        this.selectedCurrenciesList = new ArrayList<ExtendedCurrency>(this.currenciesList.size());
        this.selectedCurrenciesList.addAll(this.currenciesList);
        this.adapter = new CurrencyListAdapter((Context)this.getActivity(), this.selectedCurrenciesList);
        this.currencyListView.setAdapter((ListAdapter)this.adapter);
        this.currencyListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (CurrencyPicker.this.listener != null) {
                    ExtendedCurrency currency = (ExtendedCurrency)CurrencyPicker.this.selectedCurrenciesList.get(position);
                    CurrencyPicker.this.listener.onSelectCurrency(currency.getName(), currency.getCode(), currency.getSymbol(), currency.getFlag());
                }
            }
        });
        this.searchEditText.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                CurrencyPicker.this.search(s.toString());
            }
        });
        return view;
    }

    public void dismiss() {
        if (this.getDialog() != null) {
            super.dismiss();
        } else {
            this.getFragmentManager().popBackStack();
        }
    }

    public void setListener(CurrencyPickerListener listener) {
        this.listener = listener;
    }

    @SuppressLint(value={"DefaultLocale"})
    private void search(String text) {
        this.selectedCurrenciesList.clear();
        for (ExtendedCurrency currency : this.currenciesList) {
            if (!currency.getName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase())) continue;
            this.selectedCurrenciesList.add(currency);
        }
        this.adapter.notifyDataSetChanged();
    }

    public void setCurrenciesList(List<ExtendedCurrency> newCurrencies) {
        this.currenciesList.clear();
        this.currenciesList.addAll(newCurrencies);
    }

    public void setCurrenciesList(Set<String> savedCurrencies) {
        this.currenciesList.clear();
        for (String code : savedCurrencies) {
            this.currenciesList.add(ExtendedCurrency.getCurrencyByISO(code));
        }
    }
}

