/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.protocal.message;

import com.github.microwww.redis.protocal.message.AttrMessage;
import com.github.microwww.redis.protocal.message.Type;
import com.github.microwww.redis.util.SafeEncoder;
import java.util.Arrays;
import java.util.Objects;

public abstract class RedisMessage {
    public final Type type;
    protected final byte[] bytes;
    private AttrMessage attr;

    public RedisMessage(Type type, byte[] bytes) {
        this.type = type;
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public boolean isEmpty() {
        return this.bytes == null || this.bytes.length == 0;
    }

    public RedisMessage[] getRedisMessages() {
        return new RedisMessage[]{this};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisMessage that = (RedisMessage)o;
        return this.type == that.type && Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type});
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public AttrMessage getAttr() {
        return this.attr;
    }

    public RedisMessage setAttr(AttrMessage attr) {
        this.attr = attr;
        return this;
    }

    public String toString() {
        if (this.bytes == null) {
            return "NULL";
        }
        return SafeEncoder.encode(this.bytes);
    }
}

