/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.logger;

import com.github.microwww.redis.logger.LogFactory;
import com.github.microwww.redis.logger.Logger;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JavaLogger
implements Logger {
    public static final Level DEBUG = Level.FINE;
    java.util.logging.Logger logger;

    public JavaLogger(String name) {
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(DEBUG);
    }

    @Override
    public void debug(String var1, Object ... var2) {
        if (this.isDebugEnabled()) {
            var1 = JavaLogger.build(var1, var2);
            LogRecord rc = new LogRecord(DEBUG, var1);
            rc.setParameters(var2);
            rc.setThrown(LogFactory.getThrowable(var2));
            this.logger.log(rc);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String var1, Object ... var2) {
        if (this.isInfoEnabled()) {
            var1 = JavaLogger.build(var1, var2);
            LogRecord rc = new LogRecord(Level.INFO, var1);
            rc.setParameters(var2);
            rc.setThrown(LogFactory.getThrowable(var2));
            this.logger.log(rc);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String var1, Object ... var2) {
        if (this.isWarnEnabled()) {
            var1 = JavaLogger.build(var1, var2);
            LogRecord rc = new LogRecord(Level.WARNING, var1);
            rc.setParameters(var2);
            rc.setThrown(LogFactory.getThrowable(var2));
            this.logger.log(rc);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String var1, Object ... var2) {
        if (this.isErrorEnabled()) {
            var1 = JavaLogger.build(var1, var2);
            LogRecord rc = new LogRecord(Level.SEVERE, var1);
            rc.setParameters(var2);
            rc.setThrown(LogFactory.getThrowable(var2));
            this.logger.log(rc);
        }
    }

    public static String build(String format, Object ... param) {
        int of;
        if (param == null) {
            return format;
        }
        StringBuilder sp = new StringBuilder();
        int index = 0;
        for (int i = 0; i < param.length && (of = format.indexOf("{}", index)) >= 0; ++i) {
            sp.append(format, index, of).append("{").append(i).append("}");
            index = of + 2;
        }
        return sp.toString();
    }
}

