/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.graphics.SurfaceTexture;
import android.text.TextUtils;
import android.view.Surface;
import android.view.TextureView;
import io.microshow.rxffmpeg.player.IMediaPlayer;
import io.microshow.rxffmpeg.player.SystemMediaPlayer;
import java.lang.ref.WeakReference;

public class SystemMediaPlayerImpl
extends SystemMediaPlayer
implements TextureView.SurfaceTextureListener {
    private WeakReference<TextureView> mWeakTextureView;
    private static SurfaceTexture mSurfaceTexture;

    @Override
    public void setTextureView(TextureView textureView) {
        if (textureView != null) {
            this.mWeakTextureView = new WeakReference<TextureView>(textureView);
            textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        }
    }

    private TextureView getTextureView() {
        TextureView view;
        if (this.mWeakTextureView != null && (view = (TextureView)this.mWeakTextureView.get()) != null) {
            return view;
        }
        return null;
    }

    @Override
    public void play(String path, boolean isLooping) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            this.mMediaPlayer.reset();
            this.setDataSource(path);
            this.setLooping(isLooping);
            this.setOnPreparedListener(new IMediaPlayer.OnPreparedListener(){

                @Override
                public void onPrepared(IMediaPlayer mediaPlayer) {
                    SystemMediaPlayerImpl.this.start();
                }
            });
            this.prepare();
        }
    }

    @Override
    public void release() {
        super.release();
        if (mSurfaceTexture != null) {
            mSurfaceTexture.release();
            mSurfaceTexture = null;
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int i, int i1) {
        if (this.getTextureView() == null) {
            return;
        }
        if (mSurfaceTexture == null) {
            mSurfaceTexture = surfaceTexture;
            this.setSurface(new Surface(mSurfaceTexture));
        } else if (this.getTextureView() != null) {
            this.getTextureView().setSurfaceTexture(mSurfaceTexture);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int i, int i1) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }
}

