/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.media.MediaPlayer;
import android.os.Build;
import android.view.Surface;
import io.microshow.rxffmpeg.player.BaseMediaPlayer;
import io.microshow.rxffmpeg.player.IMediaPlayer;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public abstract class SystemMediaPlayer
extends BaseMediaPlayer {
    public MediaPlayer mMediaPlayer = new MediaPlayer();
    protected String path;
    public int volumePercent = -1;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private Disposable mTimeUpdateDisposable;

    @Override
    public void setSurface(Surface surface) {
        if (surface != null) {
            this.mMediaPlayer.setSurface(surface);
        }
    }

    @Override
    public void setDataSource(String path) {
        try {
            this.path = path;
            this.mMediaPlayer.setDataSource(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void prepare() {
        this.mMediaPlayer.prepareAsync();
    }

    @Override
    public void pause() {
        this.mMediaPlayer.pause();
        this.cancelTimeUpdateDisposable();
    }

    @Override
    public void resume() {
        this.start();
    }

    @Override
    public void start() {
        this.mMediaPlayer.start();
        this.startTimeUpdateDisposable();
    }

    @Override
    public void stop() {
        this.mMediaPlayer.stop();
    }

    @Override
    public void seekTo(int secds) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.mMediaPlayer.seekTo((long)secds, 3);
        } else {
            this.mMediaPlayer.seekTo(secds);
        }
    }

    @Override
    public int getDuration() {
        return this.mMediaPlayer.getDuration();
    }

    @Override
    public void setLooping(boolean looping) {
        this.mMediaPlayer.setLooping(looping);
    }

    @Override
    public boolean isLooping() {
        return this.mMediaPlayer.isLooping();
    }

    @Override
    public boolean isPlaying() {
        return this.mMediaPlayer.isPlaying();
    }

    @Override
    public void setVolume(int percent) {
        this.volumePercent = percent;
        this.mMediaPlayer.setVolume((float)percent / 100.0f, (float)percent / 100.0f);
    }

    @Override
    public int getVolume() {
        return this.volumePercent;
    }

    @Override
    public void setMuteSolo(int mute) {
    }

    @Override
    public int getMuteSolo() {
        return 0;
    }

    @Override
    public void release() {
        this.setOnPreparedListener(null);
        this.setOnVideoSizeChangedListener(null);
        this.setOnLoadingListener(null);
        this.setOnTimeUpdateListener(null);
        this.setOnErrorListener(null);
        this.setOnCompleteListener(null);
        this.cancelTimeUpdateDisposable();
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
            this.mCompositeDisposable = null;
        }
        this.mMediaPlayer.release();
    }

    @Override
    public void setOnPreparedListener(final IMediaPlayer.OnPreparedListener listener) {
        super.setOnPreparedListener(listener);
        this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                if (listener != null) {
                    listener.onPrepared(SystemMediaPlayer.this);
                }
            }
        });
    }

    @Override
    public void setOnVideoSizeChangedListener(final IMediaPlayer.OnVideoSizeChangedListener listener) {
        super.setOnVideoSizeChangedListener(listener);
        this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

            public void onVideoSizeChanged(MediaPlayer mediaPlayer, int width, int height) {
                if (listener != null) {
                    listener.onVideoSizeChanged(SystemMediaPlayer.this, width, height, (float)width / (float)height);
                }
            }
        });
    }

    @Override
    public void setOnLoadingListener(IMediaPlayer.OnLoadingListener listener) {
        super.setOnLoadingListener(listener);
    }

    @Override
    public void setOnErrorListener(final IMediaPlayer.OnErrorListener listener) {
        super.setOnErrorListener(listener);
        this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
                if (listener != null && what != -38) {
                    listener.onError(SystemMediaPlayer.this, what, extra + "");
                }
                return true;
            }
        });
    }

    @Override
    public void setOnCompleteListener(final IMediaPlayer.OnCompletionListener listener) {
        super.setOnCompleteListener(listener);
        this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                if (listener != null) {
                    listener.onCompletion(SystemMediaPlayer.this);
                }
            }
        });
    }

    @Override
    public void setOnTimeUpdateListener(IMediaPlayer.OnTimeUpdateListener listener) {
        super.setOnTimeUpdateListener(listener);
        this.mMediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

            public boolean onInfo(MediaPlayer mediaPlayer, int what, int extra) {
                if (what == 3 || what == 700) {
                    if (SystemMediaPlayer.this.mOnLoadingListener != null) {
                        SystemMediaPlayer.this.mOnLoadingListener.onLoading(SystemMediaPlayer.this, false);
                    }
                    return true;
                }
                if (what == 701) {
                    if (SystemMediaPlayer.this.mOnLoadingListener != null) {
                        SystemMediaPlayer.this.mOnLoadingListener.onLoading(SystemMediaPlayer.this, true);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public void repeatPlay() {
        this.play(this.path, this.mMediaPlayer.isLooping());
    }

    private void cancelTimeUpdateDisposable() {
        if (this.mTimeUpdateDisposable != null && !this.mTimeUpdateDisposable.isDisposed()) {
            this.mTimeUpdateDisposable.dispose();
        }
    }

    public void startTimeUpdateDisposable() {
        this.cancelTimeUpdateDisposable();
        this.mTimeUpdateDisposable = Flowable.interval((long)200L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                if (SystemMediaPlayer.this.mOnTimeUpdateListener != null) {
                    SystemMediaPlayer.this.mOnTimeUpdateListener.onTimeUpdate(SystemMediaPlayer.this, SystemMediaPlayer.this.mMediaPlayer.getCurrentPosition() / 1000, SystemMediaPlayer.this.getDuration() / 1000);
                }
            }
        });
        this.mCompositeDisposable.add(this.mTimeUpdateDisposable);
    }
}

