/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.text.TextUtils;
import android.view.Surface;
import io.microshow.rxffmpeg.player.BaseMediaPlayer;
import io.reactivex.Flowable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;

public abstract class RxFFmpegPlayer
extends BaseMediaPlayer {
    protected String path;
    protected int mDuration = 0;
    protected boolean looping;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private Disposable mTimeDisposable;

    private native void nativeSetSurface(Surface var1);

    private native void nativePrepare(String var1);

    private native void nativeStart();

    private native void nativePause();

    private native void nativeResume();

    private native void nativeStop();

    private native void nativeRelease();

    private native void nativeSeekTo(int var1);

    private native boolean nativeIsPlaying();

    private native void nativeSetVolume(int var1);

    private native int nativeGetVolume();

    private native void nativeSetMuteSolo(int var1);

    private native int nativeGetMuteSolo();

    @Override
    public void setSurface(Surface surface) {
        if (surface != null) {
            this.nativeSetSurface(surface);
        }
    }

    @Override
    public void setDataSource(String path) {
        this.path = path;
    }

    @Override
    public void prepare() {
        if (!TextUtils.isEmpty((CharSequence)this.path)) {
            this.nativePrepare(this.path);
        }
    }

    @Override
    public void pause() {
        this.nativePause();
    }

    @Override
    public void resume() {
        this.nativeResume();
    }

    @Override
    public void start() {
        if (!TextUtils.isEmpty((CharSequence)this.path)) {
            this.nativeStart();
        }
    }

    @Override
    public void stop() {
        this.cancelTimeDisposable();
        this.nativeStop();
    }

    @Override
    public void seekTo(int secds) {
        this.nativeSeekTo(secds);
    }

    @Override
    public int getDuration() {
        return this.mDuration;
    }

    @Override
    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    @Override
    public boolean isLooping() {
        return this.looping;
    }

    @Override
    public boolean isPlaying() {
        return this.nativeIsPlaying();
    }

    @Override
    public void setVolume(int percent) {
        this.nativeSetVolume(percent);
    }

    @Override
    public int getVolume() {
        return this.nativeGetVolume();
    }

    @Override
    public void setMuteSolo(int mute) {
        this.nativeSetMuteSolo(mute);
    }

    @Override
    public int getMuteSolo() {
        return this.nativeGetMuteSolo();
    }

    @Override
    public void release() {
        this.setOnPreparedListener(null);
        this.setOnVideoSizeChangedListener(null);
        this.setOnLoadingListener(null);
        this.setOnTimeUpdateListener(null);
        this.setOnErrorListener(null);
        this.setOnCompleteListener(null);
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
            this.mCompositeDisposable = null;
        }
        this.nativeRelease();
    }

    @Override
    public void repeatPlay() {
        this.play(this.path, this.looping);
    }

    private void cancelTimeDisposable() {
        if (this.mTimeDisposable != null && !this.mTimeDisposable.isDisposed()) {
            this.mTimeDisposable.dispose();
        }
    }

    public void onPreparedNative() {
        if (this.mOnPreparedListener != null) {
            this.mOnPreparedListener.onPrepared(this);
        }
    }

    public void onVideoSizeChangedNative(int width, int height, float dar) {
        if (this.mOnVideoSizeChangedListener != null) {
            this.mOnVideoSizeChangedListener.onVideoSizeChanged(this, width, height, dar);
        }
    }

    public void onLoadingNative(boolean load) {
        if (this.mOnLoadingListener != null) {
            this.mOnLoadingListener.onLoading(this, load);
        }
    }

    public void onTimeUpdateNative(int currentTime, int totalTime) {
        if (this.mOnTimeUpdateListener != null) {
            this.mDuration = totalTime;
            this.mOnTimeUpdateListener.onTimeUpdate(this, currentTime, totalTime);
        }
    }

    public void onErrorNative(int code, String msg) {
        if (this.mOnErrorListener != null) {
            this.mOnErrorListener.onError(this, code, msg);
        }
    }

    public void onCompletionNative() {
        if (this.mOnCompletionListener != null) {
            this.mOnCompletionListener.onCompletion(this);
        }
        if (this.isLooping()) {
            this.mTimeDisposable = Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    RxFFmpegPlayer.this.play(RxFFmpegPlayer.this.path, RxFFmpegPlayer.this.looping);
                }
            });
            this.mCompositeDisposable.add(this.mTimeDisposable);
        }
    }

    static {
        System.loadLibrary("rxffmpeg-core");
        System.loadLibrary("rxffmpeg-player");
    }
}

