/*
 * Decompiled with CFR 0.152.
 */
package io.microshow.rxffmpeg.player;

import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.microshow.rxffmpeg.player.Helper;
import io.microshow.rxffmpeg.player.RxFFmpegPlayerView;
import java.lang.ref.WeakReference;

public class MeasureHelper {
    private WeakReference<View> mWeakView;
    private VideoSizeInfo mVideoSizeInfo;
    private int mMeasuredWidth;
    private int mMeasuredHeight;
    private FitModel mFitModel = FitModel.FM_DEFAULT;

    public void setFitModel(FitModel fitModel) {
        this.mFitModel = fitModel;
    }

    public FitModel getFitModel() {
        return this.mFitModel;
    }

    public MeasureHelper(View view) {
        this.mWeakView = new WeakReference<View>(view);
    }

    public View getView() {
        View view;
        if (this.mWeakView != null && (view = (View)this.mWeakView.get()) != null) {
            return view;
        }
        return null;
    }

    public void setVideoSizeInfo(VideoSizeInfo videoSizeInfo) {
        this.mVideoSizeInfo = videoSizeInfo;
    }

    public VideoSizeInfo getVideoSizeInfo() {
        return this.mVideoSizeInfo;
    }

    public boolean isFullScreen() {
        return false;
    }

    public void setDefaultVideoLayoutParams() {
        View view = this.getView();
        RxFFmpegPlayerView mPlayerView = null;
        if (view instanceof RxFFmpegPlayerView) {
            mPlayerView = (RxFFmpegPlayerView)view;
            int width = Helper.getScreenWidth(view.getContext());
            int height = width * 9 / 16;
            this.setVideoSizeInfo(new VideoSizeInfo(width, height, (float)width / (float)height));
            this.setVideoLayoutParams(mPlayerView.getTextureView(), mPlayerView.getContainerView());
        }
    }

    public void setVideoLayoutParams(TextureView textureView, FrameLayout container) {
        if (textureView == null || container == null || this.getVideoSizeInfo() == null) {
            return;
        }
        int videoWidth = this.getVideoSizeInfo().getWidth();
        int videoHeight = this.getVideoSizeInfo().getHeight();
        float dar = this.getVideoSizeInfo().getDar();
        float videoAspect = (float)videoWidth / (float)videoHeight;
        int viewWidth = Helper.getScreenWidth(this.getView().getContext());
        int viewHeight = 0;
        if (this.isFullScreen()) {
            viewHeight = Helper.getScreenHeight(this.getView().getContext());
            viewWidth = (int)((float)viewHeight * videoAspect);
        } else if (videoWidth > videoHeight) {
            viewHeight = (int)((float)viewWidth / videoAspect);
        } else if (videoWidth < videoHeight) {
            viewHeight = viewWidth;
            viewWidth = (int)((float)viewHeight * videoAspect);
        } else {
            viewHeight = viewWidth;
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(viewWidth, viewHeight);
        params.gravity = 17;
        textureView.setLayoutParams((ViewGroup.LayoutParams)params);
        FrameLayout.LayoutParams containerParams = new FrameLayout.LayoutParams(Helper.getScreenWidth(this.getView().getContext()), viewHeight);
        container.setLayoutParams((ViewGroup.LayoutParams)containerParams);
        this.mMeasuredHeight = viewHeight;
        this.getView().requestLayout();
    }

    public int[] doMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int viewHeight;
        int viewWidth;
        if (this.mFitModel == FitModel.FM_DEFAULT) {
            viewWidth = widthMeasureSpec;
            viewHeight = this.mMeasuredHeight;
        } else {
            viewWidth = widthMeasureSpec;
            viewHeight = heightMeasureSpec;
        }
        int[] size = new int[]{viewWidth, viewHeight};
        return size;
    }

    public static class VideoSizeInfo {
        private int mWidth;
        private int mHeight;
        private float mDar;

        public VideoSizeInfo(int width, int height, float dar) {
            this.mWidth = width;
            this.mHeight = height;
            this.mDar = dar;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public float getDar() {
            return this.mDar;
        }
    }

    public static enum FitModel {
        FM_DEFAULT;

    }
}

