/*
 * Decompiled with CFR 0.152.
 */
package com.github.miachm.sods;

import com.github.miachm.sods.A1NotationCord;
import com.github.miachm.sods.Cell;
import com.github.miachm.sods.ColumnStyle;
import com.github.miachm.sods.Range;
import com.github.miachm.sods.RowStyle;
import java.util.ArrayList;
import java.util.List;

public class Sheet
implements Cloneable,
Comparable<Sheet> {
    private List<List<Cell>> cells = new ArrayList<List<Cell>>();
    private List<RowStyle> rowStyles = new ArrayList<RowStyle>();
    private List<ColumnStyle> columnStyles = new ArrayList<ColumnStyle>();
    private String name;
    private int numColumns = 0;
    private int numRows = 0;
    private boolean isHidden = false;

    public Sheet(String name) {
        this(name, 1, 1);
    }

    public Sheet(String name, int rows, int columns) {
        if (rows < 0 || columns < 0) {
            throw new IllegalArgumentException("Rows/Columns can't be negative");
        }
        this.name = name;
        this.appendColumns(columns);
        this.appendRows(rows);
    }

    public void appendRow() {
        this.appendRows(1);
    }

    public void appendRows(int howmany) {
        this.insertRowsAfter(this.getMaxRows() - 1, howmany);
    }

    public void appendColumn() {
        this.appendColumns(1);
    }

    public void appendColumns(int howmany) {
        this.insertColumnsAfter(this.getMaxColumns() - 1, howmany);
    }

    public void clear() {
        this.getDataRange().clear();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void deleteColumn(int column) {
        this.deleteColumns(column, 1);
    }

    public void deleteColumns(int column, int howmany) {
        if (column + howmany > this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column " + column + " plus " + howmany + " is out of bounds (" + this.getMaxColumns() + ")");
        }
        this.numColumns -= howmany;
        int lastColumn = this.getLastColumn();
        howmany = Math.min(howmany, lastColumn - column);
        for (List<Cell> row : this.cells) {
            for (int i = 0; i < howmany; ++i) {
                row.remove(column);
            }
        }
        for (int i = 0; i < howmany; ++i) {
            this.columnStyles.remove(column);
        }
    }

    public void deleteRow(int row) {
        this.deleteRows(row, 1);
    }

    public void deleteRows(int row, int howmany) {
        if (row > this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row " + row + " is out of bounds (" + this.getMaxRows() + ")");
        }
        for (int i = 0; i < howmany && row < this.getLastRow(); ++i) {
            this.cells.remove(row);
            this.rowStyles.remove(row);
        }
        this.numRows -= howmany;
    }

    public Double getColumnWidth(int column) {
        this.checkColumnRange(column);
        if (!this.isColumnLoaded(column)) {
            return null;
        }
        return this.columnStyles.get(column).getWidth();
    }

    public Double getRowHeight(int row) {
        this.checkRowRange(row);
        if (!this.isRowLoaded(row)) {
            return null;
        }
        return this.rowStyles.get(row).getHeight();
    }

    public Range getDataRange() {
        return this.getRange(0, 0, this.getMaxRows(), this.getMaxColumns());
    }

    public int getMaxColumns() {
        return this.numColumns;
    }

    public int getMaxRows() {
        return this.numRows;
    }

    public String getName() {
        return this.name;
    }

    public Range getRange(int row, int column) {
        return this.getRange(row, column, 1, 1);
    }

    public Range getRange(int row, int column, int numRows) {
        return this.getRange(row, column, numRows, 1);
    }

    public Range getRange(int row, int column, int numRows, int numColumns) {
        return new Range(this, row, column, numRows, numColumns);
    }

    public Range getRange(String a1Notation) {
        A1NotationCord cord = new A1NotationCord(a1Notation);
        int row = cord.getInitRow();
        int column = cord.getInitColumn();
        int numRows = cord.getLastRow() - cord.getInitRow() + 1;
        int numColumns = cord.getLastColumn() - cord.getInitColumn() + 1;
        return this.getRange(row, column, numRows, numColumns);
    }

    Cell getCell(int row, int column) {
        this.checkLazyRowLoading(row);
        this.checkLazyColumnLoading(column);
        return this.cells.get(row).get(column);
    }

    private void checkLazyRowLoading(int row) {
        while (row >= this.getLastRow()) {
            ArrayList<Cell> rowItem = new ArrayList<Cell>();
            for (int i = 0; i < this.getLastColumn(); ++i) {
                rowItem.add(new Cell());
            }
            this.cells.add(rowItem);
            this.rowStyles.add(new RowStyle());
        }
    }

    private void checkLazyColumnLoading(int column) {
        int diff = column - this.getLastColumn() + 1;
        if (diff > 0) {
            for (List<Cell> rowItem : this.cells) {
                for (int i = 0; i < diff; ++i) {
                    rowItem.add(new Cell());
                }
            }
            for (int i = 0; i < diff; ++i) {
                this.columnStyles.add(new ColumnStyle());
            }
        }
    }

    public void hideRow(int row) {
        this.checkRowRange(row);
        this.checkLazyRowLoading(row);
        this.rowStyles.get(row).setHidden(true);
    }

    public void hideColumn(int column) {
        this.checkColumnRange(column);
        this.checkLazyColumnLoading(column);
        this.columnStyles.get(column).setHidden(true);
    }

    public void insertColumnAfter(int afterPosition) {
        this.insertColumnsAfter(afterPosition, 1);
    }

    public void insertColumnBefore(int beforePosition) {
        this.insertColumnsBefore(beforePosition, 1);
    }

    public void insertColumnsAfter(int columnIndex, int howmany) {
        this.insertColumnsBefore(columnIndex + 1, howmany);
    }

    public void insertColumnsBefore(int columnIndex, int howmany) {
        if (columnIndex - 1 > this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column " + columnIndex + " is out of bounds (" + this.getMaxColumns() + ")");
        }
        if (columnIndex <= this.getLastColumn() - 1) {
            for (List<Cell> row : this.cells) {
                for (int i = 0; i < howmany; ++i) {
                    row.add(columnIndex, new Cell());
                }
            }
            for (int i = 0; i < howmany; ++i) {
                this.columnStyles.add(new ColumnStyle());
            }
        }
        this.numColumns += howmany;
    }

    public void insertRowAfter(int afterPosition) {
        this.insertRowsAfter(afterPosition, 1);
    }

    public void insertRowBefore(int beforePosition) {
        this.insertRowsBefore(beforePosition, 1);
    }

    public void insertRowsBefore(int rowIndex, int howmany) {
        if (rowIndex - 1 > this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row " + rowIndex + " is out of bounds (" + this.getMaxRows() + ")");
        }
        if (rowIndex <= this.getLastRow() - 1) {
            for (int i = 0; i < howmany; ++i) {
                ArrayList<Cell> row = new ArrayList<Cell>();
                for (int j = 0; j < this.numColumns; ++j) {
                    row.add(new Cell());
                }
                this.cells.add(rowIndex, row);
                this.rowStyles.add(new RowStyle());
            }
        }
        this.numRows += howmany;
    }

    public void insertRowsAfter(int rowIndex, int howmany) {
        this.insertRowsBefore(rowIndex + 1, howmany);
    }

    public void setColumnWidth(int column, Double width) {
        this.checkColumnRange(column);
        if (width != null && width < 0.0) {
            throw new IllegalArgumentException("Width can't be negative!");
        }
        this.checkLazyColumnLoading(column);
        this.columnStyles.get(column).setWidth(width);
    }

    public void setColumnWidths(int column, int numColumns, Double width) {
        for (int i = 0; i < numColumns; ++i) {
            this.setColumnWidth(column + i, width);
        }
    }

    public void setRowHeight(int row, Double height) {
        this.checkRowRange(row);
        if (height != null && height < 0.0) {
            throw new IllegalArgumentException("Height can't be negative!");
        }
        this.checkLazyRowLoading(row);
        this.rowStyles.get(row).setHeight(height);
    }

    public void setRowHeights(int row, int numRows, Double height) {
        for (int i = 0; i < numRows; ++i) {
            this.setRowHeight(row + i, height);
        }
    }

    public void showRow(int row) {
        this.checkRowRange(row);
        this.checkLazyRowLoading(row);
        this.rowStyles.get(row).setHidden(false);
    }

    public void showColumn(int column) {
        this.checkColumnRange(column);
        this.checkLazyColumnLoading(column);
        this.columnStyles.get(column).setHidden(false);
    }

    public boolean rowIsHidden(int row) {
        this.checkRowRange(row);
        if (!this.isRowLoaded(row)) {
            return false;
        }
        return this.rowStyles.get(row).isHidden();
    }

    private void checkRowRange(int row) {
        if (row < 0 || row >= this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row is not a valid position: " + row);
        }
    }

    public boolean columnIsHidden(int column) {
        this.checkColumnRange(column);
        if (!this.isColumnLoaded(column)) {
            return false;
        }
        return this.columnStyles.get(column).isHidden();
    }

    private boolean isRowLoaded(int row) {
        return row < this.getLastRow();
    }

    private boolean isColumnLoaded(int column) {
        return column < this.getLastColumn();
    }

    private void checkColumnRange(int column) {
        if (column < 0 || column >= this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column is not a valid position: " + column);
        }
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void hideSheet() {
        this.isHidden = true;
    }

    public void showSheet() {
        this.isHidden = false;
    }

    public int getLastRow() {
        return this.cells.size();
    }

    public int getLastColumn() {
        return this.cells.isEmpty() ? this.columnStyles.size() : this.cells.get(0).size();
    }

    public void trim() {
        this.numRows = this.getLastRow();
        this.numColumns = this.getLastColumn();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sheet sheet = (Sheet)o;
        if (this.numColumns != sheet.numColumns) {
            return false;
        }
        if (this.numRows != sheet.numRows) {
            return false;
        }
        if (this.isHidden != sheet.isHidden) {
            return false;
        }
        int minRowSize = Math.min(this.getLastRow(), sheet.getLastRow());
        int minColumnSize = Math.min(this.getLastColumn(), sheet.getLastColumn());
        for (int i = 0; i < minRowSize; ++i) {
            if (!this.rowStyles.get(i).equals(sheet.rowStyles.get(i))) {
                return false;
            }
            for (int j = 0; j < minColumnSize; ++j) {
                if (!this.cells.get(i).get(j).equals(sheet.cells.get(i).get(j))) {
                    return false;
                }
                if (this.columnStyles.get(j).equals(sheet.columnStyles.get(j))) continue;
                return false;
            }
        }
        if (!this.hasRemainingEmptyCells(minRowSize, minColumnSize, this)) {
            return false;
        }
        if (!this.hasRemainingEmptyCells(minRowSize, minColumnSize, sheet)) {
            return false;
        }
        return this.name.equals(sheet.name);
    }

    private boolean hasRemainingEmptyCells(int minRowSize, int minColumnSize, Sheet sheet) {
        int j;
        int i;
        Cell emptyCell = new Cell();
        for (i = minRowSize; i < sheet.getLastRow(); ++i) {
            for (j = 0; j < sheet.getLastColumn(); ++j) {
                if (sheet.cells.get(i).get(j).equals(emptyCell)) continue;
                return false;
            }
        }
        for (i = 0; i < sheet.getLastRow(); ++i) {
            for (j = minColumnSize; j < sheet.getLastColumn(); ++j) {
                if (sheet.cells.get(i).get(j).equals(emptyCell)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.cells.hashCode();
        result = 31 * result + this.rowStyles.hashCode();
        result = 31 * result + this.columnStyles.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.numColumns;
        result = 31 * result + this.numRows;
        result = 31 * result + (this.isHidden ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(Sheet o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return "Sheet{\ndimensions=" + this.getLastRow() + "x" + this.getLastColumn() + ",\nname='" + this.name + '\'' + ",\nishidden=" + this.isHidden + '}';
    }
}

