/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.bosh;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;

public final class BOSHConfiguration
extends ConnectionConfiguration {
    private final boolean https;
    private final String file;
    private List<Header> httpHeaders;

    private BOSHConfiguration(Builder builder) {
        super((ConnectionConfiguration.Builder)builder);
        if (this.proxy != null && this.proxy.getProxyType() != ProxyInfo.ProxyType.HTTP) {
            throw new IllegalArgumentException("Only HTTP proxies are support with BOSH connections");
        }
        this.https = builder.https;
        this.file = builder.file.charAt(0) != '/' ? '/' + builder.file : builder.file;
        this.httpHeaders = builder.httpHeaders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isProxyEnabled() {
        return this.proxy != null;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxy;
    }

    public String getProxyAddress() {
        return this.proxy != null ? this.proxy.getProxyAddress() : null;
    }

    public int getProxyPort() {
        return this.proxy != null ? this.proxy.getProxyPort() : 8080;
    }

    public boolean isUsingHTTPS() {
        return this.https;
    }

    public URI getURI() throws URISyntaxException {
        return new URI((this.https ? "https://" : "http://") + this.host + ":" + this.port + this.file);
    }

    public List<Header> getHttpHeaders() {
        return this.httpHeaders;
    }

    public static final class Builder
    extends ConnectionConfiguration.Builder<Builder, BOSHConfiguration> {
        private boolean https;
        private String file;
        private List<Header> httpHeaders = new ArrayList<Header>();

        private Builder() {
        }

        public Builder setUseHttps(boolean useHttps) {
            this.https = useHttps;
            return this;
        }

        public Builder useHttps() {
            return this.setUseHttps(true);
        }

        public Builder setFile(String file) {
            this.file = file;
            return this;
        }

        public Builder setServiceUrl(URL serviceUrl) {
            ((Builder)((Builder)this.setUseHttps(serviceUrl.getProtocol().equalsIgnoreCase("https")).setHost(serviceUrl.getHost())).setPort(serviceUrl.getPort() == -1 ? serviceUrl.getDefaultPort() : serviceUrl.getPort())).setFile(serviceUrl.getFile()).addUserInfo(serviceUrl.getUserInfo());
            return this;
        }

        public Builder addHttpHeader(Header header) {
            this.httpHeaders.add(header);
            return this;
        }

        private Builder addUserInfo(String userInfo) {
            if (null == userInfo) {
                return this;
            }
            String[] up = userInfo.split(":");
            if (up.length != 2) {
                throw new RuntimeException("Invalid user info in URL: " + userInfo);
            }
            try {
                String username = URLDecoder.decode(up[0], "UTF-8");
                String password = URLDecoder.decode(up[1], "UTF-8");
                String auth = username + ":" + password;
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
                String authHeader = "Basic " + new String(encodedAuth);
                this.addHttpHeader((Header)new BasicHeader("Authorization", authHeader));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public BOSHConfiguration build() {
            return new BOSHConfiguration(this);
        }

        protected Builder getThis() {
            return this;
        }
    }
}

