/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.jbosh;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.AttrAccept;
import org.igniterealtime.jbosh.BOSHClientConfig;
import org.igniterealtime.jbosh.BOSHException;
import org.igniterealtime.jbosh.CMSessionParams;
import org.igniterealtime.jbosh.GZIPCodec;
import org.igniterealtime.jbosh.HTTPResponse;
import org.igniterealtime.jbosh.StaticBody;
import org.igniterealtime.jbosh.ZLIBCodec;

final class ApacheHTTPResponse
implements HTTPResponse {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ACCEPT_ENCODING_VAL = ZLIBCodec.getID() + ", " + GZIPCodec.getID();
    private static final String CHARSET = "UTF-8";
    private static final String CONTENT_TYPE = "text/xml; charset=utf-8";
    private final Lock lock = new ReentrantLock();
    private final HttpContext context;
    private final HttpClient client;
    private final HttpPost post;
    private boolean sent;
    private BOSHException toThrow;
    private AbstractBody body;
    private int statusCode;

    ApacheHTTPResponse(HttpClient client, BOSHClientConfig cfg, CMSessionParams params, AbstractBody request) {
        this.client = client;
        this.context = new BasicHttpContext();
        this.post = new HttpPost(cfg.getURI().toString());
        this.sent = false;
        try {
            AttrAccept accept;
            String xml = request.toXML();
            byte[] data = xml.getBytes(CHARSET);
            String encoding = null;
            if (cfg.isCompressionEnabled() && params != null && (accept = params.getAccept()) != null) {
                if (accept.isAccepted(ZLIBCodec.getID())) {
                    encoding = ZLIBCodec.getID();
                    data = ZLIBCodec.encode(data);
                } else if (accept.isAccepted(GZIPCodec.getID())) {
                    encoding = GZIPCodec.getID();
                    data = GZIPCodec.encode(data);
                }
            }
            ByteArrayEntity entity = new ByteArrayEntity(data);
            entity.setContentType(CONTENT_TYPE);
            if (encoding != null) {
                entity.setContentEncoding(encoding);
            }
            this.post.setEntity((HttpEntity)entity);
            if (cfg.isCompressionEnabled()) {
                this.post.setHeader(ACCEPT_ENCODING, ACCEPT_ENCODING_VAL);
            }
            for (Header header : cfg.getHttpHeaders()) {
                this.post.addHeader(header);
            }
        }
        catch (Exception e) {
            this.toThrow = new BOSHException("Could not generate request", e);
        }
    }

    @Override
    public void abort() {
        if (this.post != null) {
            this.post.abort();
            this.toThrow = new BOSHException("HTTP request aborted");
        }
    }

    @Override
    public AbstractBody getBody() throws InterruptedException, BOSHException {
        if (this.toThrow != null) {
            throw this.toThrow;
        }
        this.lock.lock();
        try {
            if (!this.sent) {
                this.awaitResponse();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.body;
    }

    @Override
    public int getHTTPStatus() throws InterruptedException, BOSHException {
        if (this.toThrow != null) {
            throw this.toThrow;
        }
        this.lock.lock();
        try {
            if (!this.sent) {
                this.awaitResponse();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.statusCode;
    }

    private synchronized void awaitResponse() throws BOSHException {
        HttpEntity entity = null;
        try {
            String encoding;
            HttpResponse httpResp = this.client.execute((HttpUriRequest)this.post, this.context);
            entity = httpResp.getEntity();
            byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
            String string = encoding = entity.getContentEncoding() != null ? entity.getContentEncoding().getValue() : null;
            if (ZLIBCodec.getID().equalsIgnoreCase(encoding)) {
                data = ZLIBCodec.decode(data);
            } else if (GZIPCodec.getID().equalsIgnoreCase(encoding)) {
                data = GZIPCodec.decode(data);
            }
            this.body = StaticBody.fromString(new String(data, CHARSET));
            this.statusCode = httpResp.getStatusLine().getStatusCode();
            this.sent = true;
        }
        catch (IOException iox) {
            this.abort();
            this.toThrow = new BOSHException("Could not obtain response", iox);
            throw this.toThrow;
        }
        catch (RuntimeException ex) {
            this.abort();
            throw ex;
        }
    }
}

