/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.FrameBufferCubemap;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ScreenUtils;
import net.mgsx.gltf.scene3d.utils.FacedMultiCubemapData;

public class IBLBuilder
implements Disposable {
    public final Color nearGroundColor = new Color();
    public final Color farGroundColor = new Color();
    public final Color nearSkyColor = new Color();
    public final Color farSkyColor = new Color();
    public final Array<Light> lights = new Array();
    public boolean renderSun = true;
    public boolean renderGradient = true;
    private final ShaderProgram sunShader;
    private ShapeRenderer shapes = new ShapeRenderer(20);
    private ShapeRenderer sunShapes;

    public static IBLBuilder createOutdoor(DirectionalLight sun) {
        IBLBuilder ibl = new IBLBuilder();
        ibl.nearGroundColor.set(0.5f, 0.45f, 0.4f, 1.0f);
        ibl.farGroundColor.set(0.3f, 0.25f, 0.2f, 1.0f);
        ibl.nearSkyColor.set(0.7f, 0.8f, 1.0f, 1.0f);
        ibl.farSkyColor.set(0.9f, 0.95f, 1.0f, 1.0f);
        Light light = new Light();
        light.direction.set(sun.direction).nor();
        light.color.set(sun.color);
        light.exponent = 30.0f;
        ibl.lights.add((Object)light);
        return ibl;
    }

    public static IBLBuilder createIndoor(DirectionalLight sun) {
        IBLBuilder ibl = new IBLBuilder();
        Color tint = new Color(1.0f, 0.9f, 0.8f, 1.0f).mul(0.3f);
        ibl.nearGroundColor.set(tint).mul(0.7f);
        ibl.farGroundColor.set(tint);
        ibl.farSkyColor.set(tint);
        ibl.nearSkyColor.set(tint).mul(2.0f);
        Light light = new Light();
        light.direction.set(sun.direction).nor();
        light.color.set(1.0f, 0.5f, 0.0f, 1.0f).mul(0.3f);
        light.exponent = 3.0f;
        ibl.lights.add((Object)light);
        return ibl;
    }

    public static IBLBuilder createCustom(DirectionalLight sun) {
        IBLBuilder ibl = new IBLBuilder();
        Light light = new Light();
        light.direction.set(sun.direction).nor();
        light.color.set(sun.color);
        light.exponent = 100.0f;
        ibl.lights.add((Object)light);
        return ibl;
    }

    private IBLBuilder() {
        this.shapes.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1.0f, 1.0f);
        this.sunShader = new ShaderProgram(Gdx.files.classpath("net/mgsx/gltf/shaders/ibl-sun.vs.glsl"), Gdx.files.classpath("net/mgsx/gltf/shaders/ibl-sun.fs.glsl"));
        if (!this.sunShader.isCompiled()) {
            throw new GdxRuntimeException(this.sunShader.getLog());
        }
        this.sunShapes = new ShapeRenderer(20, this.sunShader);
        this.sunShapes.getProjectionMatrix().setToOrtho2D(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public void dispose() {
        this.sunShader.dispose();
        this.sunShapes.dispose();
        this.shapes.dispose();
    }

    public Cubemap buildEnvMap(int size) {
        FrameBufferCubemap fbo = new FrameBufferCubemap(Pixmap.Format.RGBA8888, size, size, false){

            protected void disposeColorTexture(Cubemap colorTexture) {
            }
        };
        fbo.begin();
        while (fbo.nextSide()) {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gdx.gl.glClear(16384);
            Cubemap.CubemapSide side = fbo.getSide();
            this.renderGradient(side, 0.0f);
            this.renderLights(side, false);
        }
        fbo.end();
        Cubemap map = (Cubemap)fbo.getColorBufferTexture();
        fbo.dispose();
        return map;
    }

    public Cubemap buildIrradianceMap(int size) {
        FrameBufferCubemap fbo = new FrameBufferCubemap(Pixmap.Format.RGBA8888, size, size, false){

            protected void disposeColorTexture(Cubemap colorTexture) {
            }
        };
        fbo.begin();
        while (fbo.nextSide()) {
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gdx.gl.glClear(16384);
            Cubemap.CubemapSide side = fbo.getSide();
            this.renderGradient(side, 0.5f);
            this.renderLights(side, true);
        }
        fbo.end();
        Cubemap map = (Cubemap)fbo.getColorBufferTexture();
        fbo.dispose();
        return map;
    }

    public Cubemap buildRadianceMap(int mipMapLevels) {
        Pixmap[] maps = new Pixmap[mipMapLevels * 6];
        int index = 0;
        for (int level = 0; level < mipMapLevels; ++level) {
            int size = 1 << mipMapLevels - level - 1;
            FrameBuffer fbo = new FrameBuffer(Pixmap.Format.RGBA8888, size, size, false);
            fbo.begin();
            for (int s = 0; s < 6; ++s) {
                Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                Gdx.gl.glClear(16384);
                Cubemap.CubemapSide side = Cubemap.CubemapSide.values()[s];
                float blur = (float)level / (float)mipMapLevels;
                this.renderGradient(side, blur);
                this.renderLights(side, false);
                maps[index] = ScreenUtils.getFrameBufferPixmap((int)0, (int)0, (int)size, (int)size);
                ++index;
            }
            fbo.end();
            fbo.dispose();
        }
        FacedMultiCubemapData data = new FacedMultiCubemapData(maps, mipMapLevels);
        Cubemap map = new Cubemap((CubemapData)data);
        map.setFilter(Texture.TextureFilter.MipMap, Texture.TextureFilter.Linear);
        return map;
    }

    private void renderGradient(Cubemap.CubemapSide side, float blur) {
        if (!this.renderGradient) {
            return;
        }
        Color aveSky = this.farSkyColor.cpy().lerp(this.nearSkyColor, 0.5f);
        Color aveGnd = this.farGroundColor.cpy().lerp(this.nearGroundColor, 0.5f);
        Color ave = aveSky.cpy().lerp(aveGnd, 0.5f);
        Color aveHorizon = this.farGroundColor.cpy().lerp(this.farSkyColor, 0.5f);
        float t2 = 1.0f - (float)Math.pow(1.0f - blur, 4.0);
        float t = 1.0f - (float)Math.pow(1.0f - blur, 1.0);
        Color ngc = this.nearGroundColor.cpy().lerp(ave, t);
        Color nsc = this.nearSkyColor.cpy().lerp(ave, t);
        Color fgc = this.farGroundColor.cpy().lerp(aveHorizon, t2).lerp(ave, t);
        Color fsc = this.farSkyColor.cpy().lerp(aveHorizon, t2).lerp(ave, t);
        this.shapes.begin(ShapeRenderer.ShapeType.Filled);
        if (side == Cubemap.CubemapSide.PositiveY) {
            this.shapes.rect(0.0f, 0.0f, 1.0f, 1.0f, nsc, nsc, nsc, nsc);
        } else if (side == Cubemap.CubemapSide.NegativeY) {
            this.shapes.rect(0.0f, 0.0f, 1.0f, 1.0f, ngc, ngc, ngc, ngc);
        } else {
            this.shapes.rect(0.0f, 0.0f, 1.0f, 0.5f, nsc, nsc, fsc, fsc);
            this.shapes.rect(0.0f, 0.5f, 1.0f, 0.5f, fgc, fgc, ngc, ngc);
        }
        this.shapes.end();
    }

    private void renderLights(Cubemap.CubemapSide side, boolean blured) {
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 1);
        for (Light light : this.lights) {
            if (blured) {
                light.render(side, this.sunShapes, this.sunShader, 0.5f, 1.0f);
                continue;
            }
            light.render(side, this.sunShapes, this.sunShader, 1.0f);
        }
        Gdx.gl.glDisable(3042);
        Gdx.gl.glBlendFunc(770, 771);
    }

    public static class Light {
        public final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public final Vector3 direction = new Vector3(0.0f, -1.0f, 0.0f);
        public float exponent = 30.0f;
        private static final Vector3 localSunDir = new Vector3();
        private static final Vector3 localDir = new Vector3();
        private static final Vector3 localUp = new Vector3();
        private static final Matrix4 matrix = new Matrix4();

        private void render(Cubemap.CubemapSide side, ShapeRenderer shapes, ShaderProgram shader, float strength) {
            this.render(side, shapes, shader, strength, this.exponent);
        }

        private void render(Cubemap.CubemapSide side, ShapeRenderer shapes, ShaderProgram shader, float strength, float exponent) {
            shader.begin();
            shader.setUniformf("u_exponent", exponent);
            shader.setUniformf("u_ambient", this.color.r, this.color.g, this.color.b, 0.0f);
            shader.setUniformf("u_diffuse", this.color.r, this.color.g, this.color.b, strength);
            localDir.set(side.direction);
            localUp.set(side.up);
            if (side == Cubemap.CubemapSide.NegativeX || side == Cubemap.CubemapSide.PositiveX) {
                Light.localDir.x = -Light.localDir.x;
            }
            matrix.setToLookAt(localDir, localUp).tra();
            localSunDir.set(this.direction).scl(-1.0f, -1.0f, 1.0f).mul(matrix);
            shader.setUniformf("u_direction", localSunDir);
            shapes.begin(ShapeRenderer.ShapeType.Filled);
            shapes.rect(0.0f, 0.0f, 1.0f, 1.0f);
            shapes.end();
        }
    }
}

