/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.shaders;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.shaders.DepthShader;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.DepthShaderProvider;
import com.badlogic.gdx.utils.GdxRuntimeException;
import net.mgsx.gltf.scene3d.attributes.FogAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRCubemapAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRFlagAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;
import net.mgsx.gltf.scene3d.shaders.PBRCommon;
import net.mgsx.gltf.scene3d.shaders.PBRDepthShaderProvider;
import net.mgsx.gltf.scene3d.shaders.PBRShader;
import net.mgsx.gltf.scene3d.shaders.PBRShaderConfig;
import net.mgsx.gltf.scene3d.utils.LightUtils;

public class PBRShaderProvider
extends DefaultShaderProvider {
    public static final String TAG = "PBRShader";
    private static final LightUtils.LightsInfo lightsInfo = new LightUtils.LightsInfo();

    public static PBRShaderConfig createDefaultConfig() {
        PBRShaderConfig config = new PBRShaderConfig();
        config.vertexShader = Gdx.files.classpath("net/mgsx/gltf/shaders/gdx-pbr.vs.glsl").readString();
        config.fragmentShader = Gdx.files.classpath("net/mgsx/gltf/shaders/gdx-pbr.fs.glsl").readString();
        return config;
    }

    public static DepthShader.Config createDefaultDepthConfig() {
        DepthShader.Config config = new DepthShader.Config();
        config.vertexShader = Gdx.files.classpath("net/mgsx/gltf/shaders/depth.vs.glsl").readString();
        config.fragmentShader = Gdx.files.classpath("net/mgsx/gltf/shaders/depth.fs.glsl").readString();
        return config;
    }

    public static PBRShaderProvider createDefault(int maxBones) {
        PBRShaderConfig config = PBRShaderProvider.createDefaultConfig();
        config.numBones = maxBones;
        return PBRShaderProvider.createDefault(config);
    }

    public static PBRShaderProvider createDefault(PBRShaderConfig config) {
        return new PBRShaderProvider(config);
    }

    public static DepthShaderProvider createDefaultDepth(int maxBones) {
        DepthShader.Config config = PBRShaderProvider.createDefaultDepthConfig();
        config.numBones = maxBones;
        return PBRShaderProvider.createDefaultDepth(config);
    }

    public static DepthShaderProvider createDefaultDepth(DepthShader.Config config) {
        return new PBRDepthShaderProvider(config);
    }

    public PBRShaderProvider(PBRShaderConfig config) {
        super((DefaultShader.Config)config);
    }

    public int getShaderCount() {
        return this.shaders.size;
    }

    public static String morphTargetsPrefix(Renderable renderable) {
        String prefix = "";
        for (VertexAttribute att : renderable.meshPart.mesh.getVertexAttributes()) {
            for (int i = 0; i < 8; ++i) {
                if (att.usage == 512 && att.unit == i) {
                    prefix = prefix + "#define position" + i + "Flag\n";
                    continue;
                }
                if (att.usage == 1024 && att.unit == i) {
                    prefix = prefix + "#define normal" + i + "Flag\n";
                    continue;
                }
                if (att.usage != 2048 || att.unit != i) continue;
                prefix = prefix + "#define tangent" + i + "Flag\n";
            }
        }
        return prefix;
    }

    protected Shader createShader(Renderable renderable) {
        PBRShaderConfig config = (PBRShaderConfig)this.config;
        String prefix = DefaultShader.createPrefix((Renderable)renderable, (DefaultShader.Config)config);
        String version = config.glslVersion;
        boolean openGL3 = Gdx.graphics.getGLVersion().isVersionEqualToOrHigher(3, 0);
        if (openGL3) {
            if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
                if (version == null) {
                    version = "#version 130\n#define GLSL3\n";
                }
            } else if (Gdx.app.getType() == Application.ApplicationType.Android && version == null) {
                version = "#version 300 es\n#define GLSL3\n";
            }
        }
        if (version != null) {
            prefix = version + prefix;
        }
        if ((Gdx.app.getType() == Application.ApplicationType.WebGL || !openGL3) && renderable.meshPart.mesh.getVertexAttribute(128) == null && config.useTangentSpace) {
            if (Gdx.graphics.supportsExtension("GL_OES_standard_derivatives")) {
                prefix = prefix + "#define USE_DERIVATIVES_EXT\n";
            } else {
                throw new GdxRuntimeException("GL_OES_standard_derivatives extension or tangent vertex attribute required");
            }
        }
        prefix = prefix + PBRShaderProvider.morphTargetsPrefix(renderable);
        if (renderable.material.has(PBRFlagAttribute.Unlit)) {
            prefix = prefix + "#define unlitFlag\n";
        } else {
            if (renderable.material.has(PBRTextureAttribute.MetallicRoughnessTexture)) {
                prefix = prefix + "#define metallicRoughnessTextureFlag\n";
            }
            if (renderable.material.has(PBRTextureAttribute.OcclusionTexture)) {
                prefix = prefix + "#define occlusionTextureFlag\n";
            }
            PBRCubemapAttribute specualarCubemapAttribute = null;
            if (renderable.environment != null) {
                if (renderable.environment.has(PBRCubemapAttribute.SpecularEnv)) {
                    prefix = prefix + "#define diffuseSpecularEnvSeparateFlag\n";
                    specualarCubemapAttribute = (PBRCubemapAttribute)renderable.environment.get(PBRCubemapAttribute.class, PBRCubemapAttribute.SpecularEnv);
                } else if (renderable.environment.has(PBRCubemapAttribute.DiffuseEnv)) {
                    specualarCubemapAttribute = (PBRCubemapAttribute)renderable.environment.get(PBRCubemapAttribute.class, PBRCubemapAttribute.DiffuseEnv);
                } else if (renderable.environment.has(PBRCubemapAttribute.EnvironmentMap)) {
                    specualarCubemapAttribute = (PBRCubemapAttribute)renderable.environment.get(PBRCubemapAttribute.class, PBRCubemapAttribute.EnvironmentMap);
                }
                if (specualarCubemapAttribute != null) {
                    Texture.TextureFilter textureFilter;
                    boolean textureLodSupported;
                    prefix = prefix + "#define USE_IBL\n";
                    if (openGL3) {
                        textureLodSupported = true;
                    } else if (Gdx.graphics.supportsExtension("EXT_shader_texture_lod")) {
                        prefix = prefix + "#define USE_TEXTURE_LOD_EXT\n";
                        textureLodSupported = true;
                    } else {
                        textureLodSupported = false;
                    }
                    Texture.TextureFilter textureFilter2 = textureFilter = specualarCubemapAttribute.textureDescription.minFilter != null ? specualarCubemapAttribute.textureDescription.minFilter : ((Cubemap)specualarCubemapAttribute.textureDescription.texture).getMinFilter();
                    if (textureLodSupported && textureFilter.equals((Object)Texture.TextureFilter.MipMap)) {
                        prefix = prefix + "#define USE_TEX_LOD\n";
                    }
                    if (renderable.environment.has(PBRTextureAttribute.BRDFLUTTexture)) {
                        prefix = prefix + "#define brdfLUTTexture\n";
                    }
                }
                if (renderable.environment.has(ColorAttribute.AmbientLight)) {
                    prefix = prefix + "#define ambientLightFlag\n";
                }
            }
            if (config.manualSRGB != PBRShaderConfig.SRGB.NONE) {
                prefix = prefix + "#define MANUAL_SRGB\n";
                if (config.manualSRGB == PBRShaderConfig.SRGB.FAST) {
                    prefix = prefix + "#define SRGB_FAST_APPROXIMATION\n";
                }
            }
        }
        int maxUVIndex = 0;
        Object attribute = (TextureAttribute)renderable.material.get(TextureAttribute.class, TextureAttribute.Diffuse);
        if (attribute != null) {
            prefix = prefix + "#define v_diffuseUV v_texCoord" + ((TextureAttribute)attribute).uvIndex + "\n";
            maxUVIndex = Math.max(maxUVIndex, ((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = (TextureAttribute)renderable.material.get(TextureAttribute.class, TextureAttribute.Emissive)) != null) {
            prefix = prefix + "#define v_emissiveUV v_texCoord" + ((TextureAttribute)attribute).uvIndex + "\n";
            maxUVIndex = Math.max(maxUVIndex, ((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = (TextureAttribute)renderable.material.get(TextureAttribute.class, TextureAttribute.Normal)) != null) {
            prefix = prefix + "#define v_normalUV v_texCoord" + ((TextureAttribute)attribute).uvIndex + "\n";
            maxUVIndex = Math.max(maxUVIndex, ((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = (TextureAttribute)renderable.material.get(TextureAttribute.class, PBRTextureAttribute.MetallicRoughnessTexture)) != null) {
            prefix = prefix + "#define v_metallicRoughnessUV v_texCoord" + ((TextureAttribute)attribute).uvIndex + "\n";
            maxUVIndex = Math.max(maxUVIndex, ((TextureAttribute)attribute).uvIndex);
        }
        if ((attribute = (TextureAttribute)renderable.material.get(TextureAttribute.class, PBRTextureAttribute.OcclusionTexture)) != null) {
            prefix = prefix + "#define v_occlusionUV v_texCoord" + ((TextureAttribute)attribute).uvIndex + "\n";
            maxUVIndex = Math.max(maxUVIndex, ((TextureAttribute)attribute).uvIndex);
        }
        if (maxUVIndex >= 0) {
            prefix = prefix + "#define textureFlag\n";
        }
        if (maxUVIndex == 1) {
            prefix = prefix + "#define textureCoord1Flag\n";
        } else if (maxUVIndex > 1) {
            throw new GdxRuntimeException("more than 2 texture coordinates attribute not supported");
        }
        if (renderable.environment.has(FogAttribute.FogEquation)) {
            prefix = prefix + "#define fogEquationFlag\n";
        }
        for (VertexAttribute attribute2 : renderable.meshPart.mesh.getVertexAttributes()) {
            if (attribute2.usage != 2) continue;
            prefix = prefix + "#define color" + attribute2.unit + "Flag\n";
        }
        int numBoneInfluence = 0;
        int numMorphTarget = 0;
        int numColor = 0;
        for (VertexAttribute attribute3 : renderable.meshPart.mesh.getVertexAttributes()) {
            if (attribute3.usage == 4) {
                throw new GdxRuntimeException("color packed attribute not supported");
            }
            if (attribute3.usage == 2) {
                numColor = Math.max(numColor, attribute3.unit + 1);
                continue;
            }
            if (attribute3.usage == 512 && attribute3.unit >= 8 || attribute3.usage == 1024 && attribute3.unit >= 8 || attribute3.usage == 2048 && attribute3.unit >= 8) {
                numMorphTarget = Math.max(numMorphTarget, attribute3.unit + 1);
                continue;
            }
            if (attribute3.usage != 64) continue;
            numBoneInfluence = Math.max(numBoneInfluence, attribute3.unit + 1);
        }
        PBRCommon.checkVertexAttributes(renderable);
        if (numBoneInfluence > 8) {
            Gdx.app.error(TAG, "more than 8 bones influence attributes not supported: " + numBoneInfluence + " found.");
        }
        if (numMorphTarget > 8) {
            Gdx.app.error(TAG, "more than 8 morph target attributes not supported: " + numMorphTarget + " found.");
        }
        if (numColor > config.numVertexColors) {
            Gdx.app.error(TAG, "more than " + config.numVertexColors + " color attributes not supported: " + numColor + " found.");
        }
        LightUtils.getLightsInfo(lightsInfo, renderable.environment);
        if (PBRShaderProvider.lightsInfo.dirLights > config.numDirectionalLights) {
            Gdx.app.error(TAG, "too many directional lights detected: " + PBRShaderProvider.lightsInfo.dirLights + "/" + config.numDirectionalLights);
        }
        if (PBRShaderProvider.lightsInfo.pointLights > config.numPointLights) {
            Gdx.app.error(TAG, "too many point lights detected: " + PBRShaderProvider.lightsInfo.pointLights + "/" + config.numPointLights);
        }
        if (PBRShaderProvider.lightsInfo.spotLights > config.numSpotLights) {
            Gdx.app.error(TAG, "too many spot lights detected: " + PBRShaderProvider.lightsInfo.spotLights + "/" + config.numSpotLights);
        }
        if (PBRShaderProvider.lightsInfo.miscLights > 0) {
            Gdx.app.error(TAG, "unknow type lights not supported.");
        }
        PBRShader shader = new PBRShader(renderable, config, prefix);
        String shaderLog = shader.program.getLog();
        if (shader.program.isCompiled()) {
            if (shaderLog.isEmpty()) {
                Gdx.app.log(TAG, "Shader compilation success");
            } else {
                Gdx.app.error(TAG, "Shader compilation warnings:\n" + shaderLog);
            }
        } else {
            throw new GdxRuntimeException("Shader compilation failed:\n" + shaderLog);
        }
        if (!shader.canRender(renderable)) {
            throw new GdxRuntimeException("cannot render with this shader");
        }
        return shader;
    }
}

