/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.shaders;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import net.mgsx.gltf.scene3d.attributes.FogAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRColorAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRCubemapAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRFloatAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;
import net.mgsx.gltf.scene3d.lights.DirectionalLightEx;
import net.mgsx.gltf.scene3d.model.WeightVector;

public class PBRShader
extends DefaultShader {
    private static final Vector2 v2 = new Vector2();
    public static final BaseShader.Uniform baseColorTextureUniform = new BaseShader.Uniform("u_diffuseTexture", PBRTextureAttribute.BaseColorTexture);
    public static final BaseShader.Setter baseColorTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((long)PBRTextureAttribute.BaseColorTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseShader.Uniform baseColorFactorUniform = new BaseShader.Uniform("u_BaseColorFactor", PBRColorAttribute.BaseColorFactor);
    public static final BaseShader.Setter baseColorFactorSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            ColorAttribute attribute = (ColorAttribute)combinedAttributes.get(ColorAttribute.class, PBRColorAttribute.BaseColorFactor);
            Color color = attribute == null ? Color.WHITE : attribute.color;
            shader.set(inputID, color);
        }
    };
    public static final BaseShader.Uniform emissiveTextureUniform = new BaseShader.Uniform("u_emissiveTexture", PBRTextureAttribute.EmissiveTexture);
    public static final BaseShader.Setter emissiveTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((long)PBRTextureAttribute.EmissiveTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseShader.Uniform normalTextureUniform = new BaseShader.Uniform("u_normalTexture", PBRTextureAttribute.NormalTexture);
    public static final BaseShader.Setter normalTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((long)PBRTextureAttribute.NormalTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseShader.Uniform metallicRoughnessTextureUniform = new BaseShader.Uniform("u_MetallicRoughnessSampler", PBRTextureAttribute.MetallicRoughnessTexture);
    public static final BaseShader.Setter metallicRoughnessTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((long)PBRTextureAttribute.MetallicRoughnessTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseShader.Uniform metallicRoughnessUniform = new BaseShader.Uniform("u_MetallicRoughnessValues");
    public static final BaseShader.Setter metallicRoughnessSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute metallicAttribute = (PBRFloatAttribute)combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.Metallic);
            PBRFloatAttribute roughnessAttribute = (PBRFloatAttribute)combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.Roughness);
            float metallic = metallicAttribute == null ? 1.0f : metallicAttribute.value;
            float roughness = roughnessAttribute == null ? 1.0f : roughnessAttribute.value;
            shader.set(inputID, v2.set(metallic, roughness));
        }
    };
    public static final BaseShader.Uniform normalScaleUniform = new BaseShader.Uniform("u_NormalScale");
    public static final BaseShader.Setter normalScaleSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute normalScaleAttribute = (PBRFloatAttribute)combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.NormalScale);
            float normalScale = normalScaleAttribute == null ? 1.0f : normalScaleAttribute.value;
            shader.set(inputID, normalScale);
        }
    };
    public static final BaseShader.Uniform occlusionStrengthUniform = new BaseShader.Uniform("u_OcclusionStrength");
    public static final BaseShader.Setter occlusionStrengthSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute occlusionStrengthAttribute = (PBRFloatAttribute)combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.OcclusionStrength);
            float occlusionStrength = occlusionStrengthAttribute == null ? 1.0f : occlusionStrengthAttribute.value;
            shader.set(inputID, occlusionStrength);
        }
    };
    public static final BaseShader.Uniform occlusionTextureUniform = new BaseShader.Uniform("u_OcclusionSampler", PBRTextureAttribute.OcclusionTexture);
    public static final BaseShader.Setter occlusionTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            int unit = shader.context.textureBinder.bind(((TextureAttribute)combinedAttributes.get((long)PBRTextureAttribute.OcclusionTexture)).textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseShader.Uniform diffuseEnvTextureUniform = new BaseShader.Uniform("u_DiffuseEnvSampler", PBRCubemapAttribute.DiffuseEnv);
    public static final BaseShader.Setter diffuseEnvTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            PBRCubemapAttribute diffuseEnvAttribute = (PBRCubemapAttribute)combinedAttributes.get(PBRCubemapAttribute.class, PBRCubemapAttribute.DiffuseEnv);
            int unit = shader.context.textureBinder.bind(diffuseEnvAttribute.textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseShader.Uniform specularEnvTextureUniform = new BaseShader.Uniform("u_SpecularEnvSampler", PBRCubemapAttribute.SpecularEnv);
    public static final BaseShader.Setter specularEnvTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            PBRCubemapAttribute specularEnvAttribute = (PBRCubemapAttribute)combinedAttributes.get(PBRCubemapAttribute.class, PBRCubemapAttribute.SpecularEnv);
            int unit = shader.context.textureBinder.bind(specularEnvAttribute.textureDescription);
            shader.set(inputID, unit);
        }
    };
    public static final BaseShader.Uniform brdfLUTTextureUniform = new BaseShader.Uniform("u_brdfLUT");
    public static final BaseShader.Setter brdfLUTTextureSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            PBRTextureAttribute attribute = (PBRTextureAttribute)combinedAttributes.get(PBRTextureAttribute.class, PBRTextureAttribute.BRDFLUTTexture);
            if (attribute != null) {
                int unit = shader.context.textureBinder.bind(attribute.textureDescription);
                shader.set(inputID, unit);
            }
        }
    };
    public static final BaseShader.Uniform shadowBiasUniform = new BaseShader.Uniform("u_shadowBias");
    public static final BaseShader.Setter shadowBiasSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            PBRFloatAttribute attribute = (PBRFloatAttribute)combinedAttributes.get(PBRFloatAttribute.class, PBRFloatAttribute.ShadowBias);
            float value = attribute == null ? 0.0f : attribute.value;
            shader.set(inputID, value);
        }
    };
    public static final BaseShader.Uniform fogEquationUniform = new BaseShader.Uniform("u_fogEquation");
    public static final BaseShader.Setter fogEquationSetter = new BaseShader.LocalSetter(){

        public void set(BaseShader shader, int inputID, Renderable renderable, Attributes combinedAttributes) {
            FogAttribute attribute = (FogAttribute)combinedAttributes.get(FogAttribute.class, FogAttribute.FogEquation);
            Vector3 value = attribute == null ? Vector3.Zero : attribute.value;
            shader.set(inputID, value);
        }
    };
    private static final PBRTextureAttribute[] transformTexture = new PBRTextureAttribute[]{null, null};
    public final int u_metallicRoughness;
    public final int u_occlusionStrength;
    public final int u_metallicRoughnessTexture;
    public final int u_occlusionTexture;
    public final int u_DiffuseEnvSampler;
    public final int u_SpecularEnvSampler;
    public final int u_brdfLUTTexture;
    public final int u_NormalScale;
    public final int u_BaseColorTexture;
    public final int u_NormalTexture;
    public final int u_EmissiveTexture;
    public final int u_BaseColorFactor;
    public final int u_FogEquation;
    public final int u_ShadowBias;
    private int u_morphTargets1;
    private int u_morphTargets2;
    private int u_mipmapScale;
    private int u_texCoord0Transform;
    private int u_texCoord1Transform;
    private int u_ambientLight;
    private long textureCoordinateMapMask;
    private long morphTargetsMask;
    private int vertexColorLayers;
    private static final Matrix3 textureTransform = new Matrix3();
    private static long[] allTextureTypes = new long[]{PBRTextureAttribute.BaseColorTexture, PBRTextureAttribute.EmissiveTexture, PBRTextureAttribute.NormalTexture, PBRTextureAttribute.MetallicRoughnessTexture, PBRTextureAttribute.OcclusionTexture};

    public PBRShader(Renderable renderable, DefaultShader.Config config, String prefix) {
        super(renderable, config, prefix);
        this.textureCoordinateMapMask = PBRShader.getTextureCoordinateMapMask((Attributes)renderable.material);
        this.morphTargetsMask = this.computeMorphTargetsMask(renderable);
        this.vertexColorLayers = this.computeVertexColorLayers(renderable);
        this.u_BaseColorTexture = this.register(baseColorTextureUniform, baseColorTextureSetter);
        this.u_BaseColorFactor = this.register(baseColorFactorUniform, baseColorFactorSetter);
        this.u_EmissiveTexture = this.register(emissiveTextureUniform, emissiveTextureSetter);
        this.u_DiffuseEnvSampler = this.register(diffuseEnvTextureUniform, diffuseEnvTextureSetter);
        this.u_SpecularEnvSampler = this.register(specularEnvTextureUniform, specularEnvTextureSetter);
        this.u_metallicRoughness = this.register(metallicRoughnessUniform, metallicRoughnessSetter);
        this.u_metallicRoughnessTexture = this.register(metallicRoughnessTextureUniform, metallicRoughnessTextureSetter);
        this.u_occlusionTexture = this.register(occlusionTextureUniform, occlusionTextureSetter);
        this.u_occlusionStrength = this.register(occlusionStrengthUniform, occlusionStrengthSetter);
        this.u_brdfLUTTexture = this.register(brdfLUTTextureUniform, brdfLUTTextureSetter);
        this.u_NormalTexture = this.register(normalTextureUniform, normalTextureSetter);
        this.u_NormalScale = this.register(normalScaleUniform, normalScaleSetter);
        this.u_ShadowBias = this.register(shadowBiasUniform, shadowBiasSetter);
        this.u_FogEquation = this.register(fogEquationUniform, fogEquationSetter);
    }

    private int computeVertexColorLayers(Renderable renderable) {
        int num = 0;
        VertexAttributes vertexAttributes = renderable.meshPart.mesh.getVertexAttributes();
        int n = vertexAttributes.size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = vertexAttributes.get(i);
            if (attr.usage != 2) continue;
            ++num;
        }
        return num;
    }

    public boolean canRender(Renderable renderable) {
        long textureCoordinateMapMask = PBRShader.getTextureCoordinateMapMask((Attributes)renderable.material);
        if (textureCoordinateMapMask != this.textureCoordinateMapMask) {
            return false;
        }
        if (this.morphTargetsMask != this.computeMorphTargetsMask(renderable)) {
            return false;
        }
        if (this.vertexColorLayers != this.computeVertexColorLayers(renderable)) {
            return false;
        }
        return super.canRender(renderable);
    }

    public long computeMorphTargetsMask(Renderable renderable) {
        int morphTargetsFlag = 0;
        VertexAttributes vertexAttributes = renderable.meshPart.mesh.getVertexAttributes();
        int n = vertexAttributes.size();
        for (int i = 0; i < n; ++i) {
            VertexAttribute attr = vertexAttributes.get(i);
            if (attr.usage == 512) {
                morphTargetsFlag |= 1 << attr.unit;
            }
            if (attr.usage == 1024) {
                morphTargetsFlag |= 1 << attr.unit + 8;
            }
            if (attr.usage != 2048) continue;
            morphTargetsFlag |= 1 << attr.unit + 16;
        }
        return morphTargetsFlag;
    }

    private static long getTextureCoordinateMapMask(Attributes attributes) {
        long mask = 0L;
        int maskShift = 0;
        for (long textureType : allTextureTypes) {
            PBRTextureAttribute attribute = (PBRTextureAttribute)attributes.get(PBRTextureAttribute.class, textureType);
            if (attribute != null) {
                mask |= (long)((attribute.uvIndex & 1) << maskShift);
            }
            ++maskShift;
        }
        return mask;
    }

    public void init(ShaderProgram program, Renderable renderable) {
        super.init(program, renderable);
        this.u_mipmapScale = program.fetchUniformLocation("u_mipmapScale", false);
        this.u_texCoord0Transform = program.fetchUniformLocation("u_texCoord0Transform", false);
        this.u_texCoord1Transform = program.fetchUniformLocation("u_texCoord1Transform", false);
        this.u_morphTargets1 = program.fetchUniformLocation("u_morphTargets1", false);
        this.u_morphTargets2 = program.fetchUniformLocation("u_morphTargets2", false);
        this.u_ambientLight = program.fetchUniformLocation("u_ambientLight", false);
    }

    protected void bindMaterial(Attributes attributes) {
        PBRTextureAttribute attribute;
        super.bindMaterial(attributes);
        PBRShader.transformTexture[0] = null;
        PBRShader.transformTexture[1] = null;
        for (long textureType : allTextureTypes) {
            PBRTextureAttribute attribute2 = (PBRTextureAttribute)attributes.get(PBRTextureAttribute.class, textureType);
            if (attribute2 == null) continue;
            PBRShader.transformTexture[attribute2.uvIndex] = attribute2;
        }
        if (this.u_texCoord0Transform >= 0) {
            if (transformTexture[0] != null) {
                attribute = transformTexture[0];
                textureTransform.idt();
                textureTransform.translate(attribute.offsetU, attribute.offsetV);
                textureTransform.rotateRad(-attribute.rotationUV);
                textureTransform.scale(attribute.scaleU, attribute.scaleV);
            } else {
                textureTransform.idt();
            }
            this.program.setUniformMatrix(this.u_texCoord0Transform, textureTransform);
        }
        if (this.u_texCoord1Transform >= 0) {
            if (transformTexture[1] != null) {
                attribute = transformTexture[1];
                textureTransform.setToTranslation(attribute.offsetU, attribute.offsetV);
                textureTransform.rotateRad(attribute.rotationUV);
                textureTransform.scale(attribute.scaleU, attribute.scaleV);
            } else {
                textureTransform.idt();
            }
            this.program.setUniformMatrix(this.u_texCoord1Transform, textureTransform);
        }
    }

    public void render(Renderable renderable, Attributes combinedAttributes) {
        WeightVector weightVector;
        if (this.u_mipmapScale >= 0) {
            PBRCubemapAttribute specularEnv = (PBRCubemapAttribute)combinedAttributes.get(PBRCubemapAttribute.class, PBRCubemapAttribute.SpecularEnv);
            float mipmapFactor = specularEnv != null ? (float)(Math.log(((Cubemap)specularEnv.textureDescription.texture).getWidth()) / Math.log(2.0)) : 1.0f;
            this.program.setUniformf(this.u_mipmapScale, mipmapFactor);
        }
        if (this.u_morphTargets1 >= 0) {
            if (renderable.userData instanceof WeightVector) {
                weightVector = (WeightVector)renderable.userData;
                this.program.setUniformf(this.u_morphTargets1, weightVector.get(0), weightVector.get(1), weightVector.get(2), weightVector.get(3));
            } else {
                this.program.setUniformf(this.u_morphTargets1, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        if (this.u_morphTargets2 >= 0) {
            if (renderable.userData instanceof WeightVector) {
                weightVector = (WeightVector)renderable.userData;
                this.program.setUniformf(this.u_morphTargets2, weightVector.get(4), weightVector.get(5), weightVector.get(6), weightVector.get(7));
            } else {
                this.program.setUniformf(this.u_morphTargets2, 0.0f, 0.0f, 0.0f, 0.0f);
            }
        }
        super.render(renderable, combinedAttributes);
    }

    protected void bindLights(Renderable renderable, Attributes attributes) {
        DirectionalLightsAttribute dla = (DirectionalLightsAttribute)attributes.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        if (dla != null) {
            for (DirectionalLight light : dla.lights) {
                if (!(light instanceof DirectionalLightEx)) continue;
                ((DirectionalLightEx)light).updateColor();
            }
        }
        super.bindLights(renderable, attributes);
        ColorAttribute ambiantLight = (ColorAttribute)attributes.get(ColorAttribute.class, ColorAttribute.AmbientLight);
        if (ambiantLight != null) {
            this.program.setUniformf(this.u_ambientLight, ambiantLight.color.r, ambiantLight.color.g, ambiantLight.color.b);
        }
    }
}

