/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.CubemapAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import net.mgsx.gltf.scene3d.scene.SceneRenderableSorter;
import net.mgsx.gltf.scene3d.scene.Updatable;

public class SceneSkybox
implements RenderableProvider,
Updatable,
Disposable {
    private DefaultShaderProvider shaderProvider;
    private Model boxModel;
    private Renderable box;

    public SceneSkybox(Cubemap cubemap) {
        DefaultShader.Config shaderConfig = new DefaultShader.Config();
        String basePathName = "net/mgsx/gltf/shaders/skybox";
        shaderConfig.vertexShader = Gdx.files.classpath(basePathName + ".vs.glsl").readString();
        shaderConfig.fragmentShader = Gdx.files.classpath(basePathName + ".fs.glsl").readString();
        this.shaderProvider = new DefaultShaderProvider(shaderConfig);
        float boxScale = (float)(1.0 / Math.sqrt(2.0));
        this.boxModel = new ModelBuilder().createBox(boxScale, boxScale, boxScale, new Material(), 1L);
        this.box = ((NodePart)((Node)this.boxModel.nodes.first()).parts.first()).setRenderable(new Renderable());
        Environment env = new Environment();
        env.set((Attribute)new CubemapAttribute(CubemapAttribute.EnvironmentMap, cubemap));
        env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, Color.WHITE));
        this.box.environment = env;
        this.box.userData = SceneRenderableSorter.Hints.OPAQUE_LAST;
        this.box.material = new Material(new Attribute[]{ColorAttribute.createDiffuse((Color)Color.WHITE)});
        this.box.material.set((Attribute)new DepthTestAttribute(false));
        this.box.shader = this.shaderProvider.getShader(this.box);
    }

    public SceneSkybox set(Cubemap cubemap) {
        this.box.environment.set((Attribute)new CubemapAttribute(CubemapAttribute.EnvironmentMap, cubemap));
        return this;
    }

    public Color getColor() {
        return ((ColorAttribute)this.box.material.get(ColorAttribute.class, (long)ColorAttribute.Diffuse)).color;
    }

    @Override
    public void update(Camera camera, float delta) {
        float s = camera.far * (float)Math.sqrt(2.0);
        this.box.worldTransform.setToScaling(s, s, s);
        this.box.worldTransform.setTranslation(camera.position);
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        renderables.add((Object)this.box);
    }

    public void dispose() {
        this.shaderProvider.dispose();
        this.boxModel.dispose();
    }
}

