/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.scene;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.SpotLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.utils.DepthShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.RenderableSorter;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import net.mgsx.gltf.scene3d.lights.DirectionalShadowLight;
import net.mgsx.gltf.scene3d.lights.PointLightEx;
import net.mgsx.gltf.scene3d.lights.SpotLightEx;
import net.mgsx.gltf.scene3d.scene.Scene;
import net.mgsx.gltf.scene3d.scene.SceneRenderableSorter;
import net.mgsx.gltf.scene3d.scene.SceneSkybox;
import net.mgsx.gltf.scene3d.scene.Updatable;
import net.mgsx.gltf.scene3d.shaders.PBRCommon;
import net.mgsx.gltf.scene3d.shaders.PBRShaderProvider;
import net.mgsx.gltf.scene3d.utils.EnvironmentCache;
import net.mgsx.gltf.scene3d.utils.EnvironmentUtil;

public class SceneManager
implements Disposable {
    private final Array<RenderableProvider> renderableProviders = new Array();
    private ModelBatch batch;
    private ModelBatch depthBatch;
    private SceneSkybox skyBox;
    public Environment environment = new Environment();
    protected final EnvironmentCache computedEnvironement = new EnvironmentCache();
    public Camera camera;
    private RenderableSorter renderableSorter;
    private PointLightsAttribute pointLights = new PointLightsAttribute();
    private SpotLightsAttribute spotLights = new SpotLightsAttribute();

    public SceneManager() {
        this(24);
    }

    public SceneManager(int maxBones) {
        this((ShaderProvider)PBRShaderProvider.createDefault(maxBones), PBRShaderProvider.createDefaultDepth(maxBones));
    }

    public SceneManager(ShaderProvider shaderProvider, DepthShaderProvider depthShaderProvider) {
        this(shaderProvider, depthShaderProvider, new SceneRenderableSorter());
    }

    public SceneManager(ShaderProvider shaderProvider, DepthShaderProvider depthShaderProvider, RenderableSorter renderableSorter) {
        this.renderableSorter = renderableSorter;
        this.batch = new ModelBatch(shaderProvider, renderableSorter);
        this.depthBatch = new ModelBatch((ShaderProvider)depthShaderProvider);
        float lum = 1.0f;
        this.environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, lum, lum, lum, 1.0f));
    }

    public ModelBatch getBatch() {
        return this.batch;
    }

    public void setBatch(ModelBatch batch) {
        this.batch = batch;
    }

    public void setShaderProvider(ShaderProvider shaderProvider) {
        this.batch.dispose();
        this.batch = new ModelBatch(shaderProvider, this.renderableSorter);
    }

    public void setDepthShaderProvider(DepthShaderProvider depthShaderProvider) {
        this.depthBatch.dispose();
        this.depthBatch = new ModelBatch((ShaderProvider)depthShaderProvider);
    }

    public void addScene(Scene scene) {
        this.addScene(scene, true);
    }

    public void addScene(Scene scene, boolean appendLights) {
        this.renderableProviders.add((Object)scene);
        if (appendLights) {
            for (ObjectMap.Entry e : scene.lights) {
                this.environment.add((BaseLight)e.value);
            }
        }
    }

    public void update(float delta) {
        if (this.camera != null) {
            this.updateEnvironment();
            for (RenderableProvider r : this.renderableProviders) {
                if (!(r instanceof Updatable)) continue;
                ((Updatable)r).update(this.camera, delta);
            }
            if (this.skyBox != null) {
                this.skyBox.update(this.camera, delta);
            }
        }
    }

    protected void updateEnvironment() {
        this.computedEnvironement.setCache(this.environment);
        this.pointLights.lights.clear();
        this.spotLights.lights.clear();
        if (this.environment != null) {
            for (Attribute a : this.environment) {
                if (a instanceof PointLightsAttribute) {
                    this.pointLights.lights.addAll(((PointLightsAttribute)a).lights);
                    this.computedEnvironement.replaceCache((Attribute)this.pointLights);
                    continue;
                }
                if (a instanceof SpotLightsAttribute) {
                    this.spotLights.lights.addAll(((SpotLightsAttribute)a).lights);
                    this.computedEnvironement.replaceCache((Attribute)this.spotLights);
                    continue;
                }
                this.computedEnvironement.set(a);
            }
        }
        this.cullLights();
    }

    protected void cullLights() {
        SpotLightsAttribute sla;
        PointLightsAttribute pla = (PointLightsAttribute)this.environment.get(PointLightsAttribute.class, PointLightsAttribute.Type);
        if (pla != null) {
            for (PointLight light : pla.lights) {
                if (!(light instanceof PointLightEx)) continue;
                PointLightEx l = (PointLightEx)light;
                if (l.range == null || this.camera.frustum.sphereInFrustum(l.position, l.range.floatValue())) continue;
                this.pointLights.lights.removeValue((Object)l, true);
            }
        }
        if ((sla = (SpotLightsAttribute)this.environment.get(SpotLightsAttribute.class, SpotLightsAttribute.Type)) != null) {
            for (SpotLight light : sla.lights) {
                if (!(light instanceof SpotLightEx)) continue;
                SpotLightEx l = (SpotLightEx)light;
                if (l.range == null || this.camera.frustum.sphereInFrustum(l.position, l.range.floatValue())) continue;
                this.spotLights.lights.removeValue((Object)l, true);
            }
        }
    }

    public void render() {
        if (this.camera == null) {
            return;
        }
        this.renderShadows();
        this.renderColors();
    }

    public void renderShadows() {
        DirectionalLight light = this.getFirstDirectionalLight();
        if (light instanceof DirectionalShadowLight) {
            DirectionalShadowLight shadowLight = (DirectionalShadowLight)light;
            shadowLight.begin();
            this.renderDepth(shadowLight.getCamera());
            shadowLight.end();
            this.environment.shadowMap = shadowLight;
        } else {
            this.environment.shadowMap = null;
        }
    }

    public void renderDepth() {
        this.renderDepth(this.camera);
    }

    private void renderDepth(Camera camera) {
        this.depthBatch.begin(camera);
        this.depthBatch.render(this.renderableProviders);
        this.depthBatch.end();
    }

    public void renderColors() {
        PBRCommon.enableSeamlessCubemaps();
        this.computedEnvironement.shadowMap = this.environment.shadowMap;
        this.batch.begin(this.camera);
        this.batch.render(this.renderableProviders, (Environment)this.computedEnvironement);
        if (this.skyBox != null) {
            this.batch.render((RenderableProvider)this.skyBox);
        }
        this.batch.end();
    }

    public DirectionalLight getFirstDirectionalLight() {
        DirectionalLightsAttribute dla = (DirectionalLightsAttribute)this.environment.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        if (dla != null) {
            for (DirectionalLight dl : dla.lights) {
                if (!(dl instanceof DirectionalLight)) continue;
                return dl;
            }
        }
        return null;
    }

    public void setSkyBox(SceneSkybox skyBox) {
        this.skyBox = skyBox;
    }

    public void setAmbientLight(float lum) {
        ((ColorAttribute)this.environment.get(ColorAttribute.class, (long)ColorAttribute.AmbientLight)).color.set(lum, lum, lum, 1.0f);
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void removeScene(Scene scene) {
        this.renderableProviders.removeValue((Object)scene, true);
        for (ObjectMap.Entry e : scene.lights) {
            this.environment.remove((BaseLight)e.value);
        }
    }

    public Array<RenderableProvider> getRenderableProviders() {
        return this.renderableProviders;
    }

    public void updateViewport(int width, int height) {
        if (this.camera != null) {
            this.camera.viewportWidth = width;
            this.camera.viewportHeight = height;
            this.camera.update(true);
        }
    }

    public int getActiveLightsCount() {
        return EnvironmentUtil.getLightCount(this.computedEnvironement);
    }

    public int getTotalLightsCount() {
        return EnvironmentUtil.getLightCount(this.environment);
    }

    public void dispose() {
        this.batch.dispose();
        this.depthBatch.dispose();
    }
}

