/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.model;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class WeightVector {
    public int count;
    public float[] values;

    public WeightVector() {
        this(0, 8);
    }

    public WeightVector(int count) {
        this(count, 8);
    }

    public WeightVector(int count, int max) {
        this.count = count;
        this.values = new float[max];
    }

    public WeightVector set(WeightVector weights) {
        if (weights.count > this.values.length) {
            this.values = new float[weights.count];
        }
        this.count = weights.count;
        for (int i = 0; i < weights.values.length; ++i) {
            this.values[i] = weights.values[i];
        }
        return this;
    }

    public void lerp(WeightVector value, float t) {
        if (this.count != value.count) {
            throw new GdxRuntimeException("WeightVector count mismatch");
        }
        for (int i = 0; i < this.count; ++i) {
            this.values[i] = MathUtils.lerp((float)this.values[i], (float)value.values[i], (float)t);
        }
    }

    public String toString() {
        String s = "WeightVector(";
        for (int i = 0; i < this.count; ++i) {
            if (i > 0) {
                s = s + ", ";
            }
            s = s + this.values[i];
        }
        return s + ")";
    }

    public WeightVector set() {
        this.count = 0;
        return this;
    }

    public WeightVector cpy() {
        return new WeightVector(this.count, this.values.length).set(this);
    }

    public float get(int index) {
        return this.values[index];
    }

    public WeightVector scl(float s) {
        int i = 0;
        while (i < this.count) {
            int n = i++;
            this.values[n] = this.values[n] * s;
        }
        return this;
    }

    public WeightVector mulAdd(WeightVector w, float s) {
        for (int i = 0; i < this.count; ++i) {
            int n = i;
            this.values[n] = this.values[n] + w.values[i] * s;
        }
        return this;
    }
}

