/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.scene3d.lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.Vector3;

public class DirectionalLightEx
extends DirectionalLight {
    public final Color baseColor = new Color(Color.WHITE);
    public float intensity = 1.0f;

    public DirectionalLight set(DirectionalLight copyFrom) {
        if (copyFrom instanceof DirectionalLightEx) {
            return this.set(((DirectionalLightEx)copyFrom).baseColor, copyFrom.direction, ((DirectionalLightEx)copyFrom).intensity);
        }
        return this.set(copyFrom.color, copyFrom.direction, 1.0f);
    }

    public DirectionalLightEx set(Color baseColor, Vector3 direction, float intensity) {
        this.intensity = intensity;
        this.baseColor.set(baseColor);
        this.direction.set(direction);
        this.updateColor();
        return this;
    }

    public void updateColor() {
        this.color.r = this.baseColor.r * this.intensity;
        this.color.g = this.baseColor.g * this.intensity;
        this.color.b = this.baseColor.b * this.intensity;
    }

    public boolean equals(DirectionalLight other) {
        return other instanceof DirectionalLightEx ? this.equals((DirectionalLightEx)other) : false;
    }

    public boolean equals(DirectionalLightEx other) {
        return other != null && (other == this || this.baseColor.equals((Object)other.baseColor) && Float.compare(this.intensity, other.intensity) == 0 && this.direction.equals((Object)other.direction));
    }
}

