/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.shared.texture;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import net.mgsx.gltf.data.texture.GLTFImage;
import net.mgsx.gltf.loaders.shared.data.DataFileResolver;

public class ImageResolver
implements Disposable {
    private Array<Pixmap> pixmaps = new Array();
    private DataFileResolver dataFileResolver;

    public ImageResolver(DataFileResolver dataFileResolver) {
        this.dataFileResolver = dataFileResolver;
    }

    public void load(Array<GLTFImage> glImages) {
        if (glImages != null) {
            for (int i = 0; i < glImages.size; ++i) {
                GLTFImage glImage = (GLTFImage)glImages.get(i);
                Pixmap pixmap = this.dataFileResolver.load(glImage);
                this.pixmaps.add((Object)pixmap);
            }
        }
    }

    public Pixmap get(int index) {
        return (Pixmap)this.pixmaps.get(index);
    }

    public void dispose() {
        for (Pixmap pixmap : this.pixmaps) {
            pixmap.dispose();
        }
        this.pixmaps.clear();
    }
}

