/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.shared.material;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import net.mgsx.gltf.data.extensions.KHRMaterialsPBRSpecularGlossiness;
import net.mgsx.gltf.data.extensions.KHRMaterialsUnlit;
import net.mgsx.gltf.data.extensions.KHRTextureTransform;
import net.mgsx.gltf.data.material.GLTFMaterial;
import net.mgsx.gltf.data.material.GLTFpbrMetallicRoughness;
import net.mgsx.gltf.data.texture.GLTFTextureInfo;
import net.mgsx.gltf.loaders.shared.GLTFTypes;
import net.mgsx.gltf.loaders.shared.material.MaterialLoaderBase;
import net.mgsx.gltf.loaders.shared.texture.TextureResolver;
import net.mgsx.gltf.scene3d.attributes.PBRColorAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRFlagAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRFloatAttribute;
import net.mgsx.gltf.scene3d.attributes.PBRTextureAttribute;

public class PBRMaterialLoader
extends MaterialLoaderBase {
    public PBRMaterialLoader(TextureResolver textureResolver) {
        super(textureResolver, new Material(new Attribute[]{new PBRColorAttribute(PBRColorAttribute.BaseColorFactor, Color.WHITE)}));
    }

    @Override
    public Material loadMaterial(GLTFMaterial glMaterial) {
        Material material = new Material();
        if (glMaterial.name != null) {
            material.id = glMaterial.name;
        }
        if (glMaterial.emissiveFactor != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, GLTFTypes.mapColor(glMaterial.emissiveFactor, Color.BLACK)));
        }
        if (glMaterial.emissiveTexture != null) {
            material.set((Attribute)this.getTexureMap(PBRTextureAttribute.EmissiveTexture, glMaterial.emissiveTexture));
        }
        if (glMaterial.doubleSided == Boolean.TRUE) {
            material.set((Attribute)IntAttribute.createCullFace((int)0));
        }
        if (glMaterial.normalTexture != null) {
            material.set((Attribute)this.getTexureMap(PBRTextureAttribute.NormalTexture, glMaterial.normalTexture));
            material.set(PBRFloatAttribute.createNormalScale(glMaterial.normalTexture.scale));
        }
        if (glMaterial.occlusionTexture != null) {
            material.set((Attribute)this.getTexureMap(PBRTextureAttribute.OcclusionTexture, glMaterial.occlusionTexture));
            material.set(PBRFloatAttribute.createOcclusionStrength(glMaterial.occlusionTexture.strength));
        }
        boolean alphaBlend = false;
        if (!"OPAQUE".equals(glMaterial.alphaMode)) {
            if ("MASK".equals(glMaterial.alphaMode)) {
                float value = glMaterial.alphaCutoff == null ? 0.5f : glMaterial.alphaCutoff.floatValue();
                material.set((Attribute)FloatAttribute.createAlphaTest((float)value));
                material.set((Attribute)new BlendingAttribute());
            } else if ("BLEND".equals(glMaterial.alphaMode)) {
                material.set((Attribute)new BlendingAttribute());
                alphaBlend = true;
            } else if (glMaterial.alphaMode != null) {
                throw new GdxRuntimeException("unknow alpha mode : " + glMaterial.alphaMode);
            }
        }
        if (glMaterial.pbrMetallicRoughness != null) {
            GLTFpbrMetallicRoughness p = glMaterial.pbrMetallicRoughness;
            Color baseColorFactor = GLTFTypes.mapColor(p.baseColorFactor, Color.WHITE);
            material.set((Attribute)new PBRColorAttribute(PBRColorAttribute.BaseColorFactor, baseColorFactor));
            material.set(PBRFloatAttribute.createMetallic(p.metallicFactor));
            material.set(PBRFloatAttribute.createRoughness(p.roughnessFactor));
            if (p.metallicRoughnessTexture != null) {
                material.set((Attribute)this.getTexureMap(PBRTextureAttribute.MetallicRoughnessTexture, p.metallicRoughnessTexture));
            }
            if (p.baseColorTexture != null) {
                material.set((Attribute)this.getTexureMap(PBRTextureAttribute.BaseColorTexture, p.baseColorTexture));
            }
            if (alphaBlend) {
                ((BlendingAttribute)material.get(BlendingAttribute.class, (long)BlendingAttribute.Type)).opacity = baseColorFactor.a;
            }
        }
        if (glMaterial.extensions != null) {
            Object ext = glMaterial.extensions.get(KHRMaterialsPBRSpecularGlossiness.class, "KHR_materials_pbrSpecularGlossiness");
            if (ext != null) {
                material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, GLTFTypes.mapColor(((KHRMaterialsPBRSpecularGlossiness)ext).diffuseFactor, Color.WHITE)));
                material.set((Attribute)new ColorAttribute(ColorAttribute.Specular, GLTFTypes.mapColor(((KHRMaterialsPBRSpecularGlossiness)ext).specularFactor, Color.WHITE)));
                material.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, MathUtils.lerp((float)1.0f, (float)100.0f, (float)((KHRMaterialsPBRSpecularGlossiness)ext).glossinessFactor)));
                if (((KHRMaterialsPBRSpecularGlossiness)ext).diffuseTexture != null) {
                    material.set((Attribute)this.getTexureMap(PBRTextureAttribute.Diffuse, ((KHRMaterialsPBRSpecularGlossiness)ext).diffuseTexture));
                }
                if (((KHRMaterialsPBRSpecularGlossiness)ext).specularGlossinessTexture != null) {
                    material.set((Attribute)this.getTexureMap(PBRTextureAttribute.Specular, ((KHRMaterialsPBRSpecularGlossiness)ext).specularGlossinessTexture));
                }
            }
            if ((ext = glMaterial.extensions.get(KHRMaterialsUnlit.class, "KHR_materials_unlit")) != null) {
                material.set((Attribute)new PBRFlagAttribute(PBRFlagAttribute.Unlit));
            }
        }
        return material;
    }

    private PBRTextureAttribute getTexureMap(long type, GLTFTextureInfo glMap) {
        KHRTextureTransform ext;
        TextureDescriptor<Texture> textureDescriptor = this.textureResolver.getTexture(glMap);
        PBRTextureAttribute attribute = new PBRTextureAttribute(type, textureDescriptor);
        attribute.uvIndex = glMap.texCoord;
        if (glMap.extensions != null && (ext = glMap.extensions.get(KHRTextureTransform.class, "KHR_texture_transform")) != null) {
            attribute.offsetU = ext.offset[0];
            attribute.offsetV = ext.offset[1];
            attribute.scaleU = ext.scale[0];
            attribute.scaleV = ext.scale[1];
            attribute.rotationUV = ext.rotation;
            if (ext.texCoord != null) {
                attribute.uvIndex = ext.texCoord;
            }
        }
        return attribute;
    }
}

