/*
 * Decompiled with CFR 0.152.
 */
package net.mgsx.gltf.loaders.shared.material;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.utils.Array;
import net.mgsx.gltf.data.material.GLTFMaterial;
import net.mgsx.gltf.loaders.shared.material.MaterialLoader;
import net.mgsx.gltf.loaders.shared.texture.TextureResolver;

public abstract class MaterialLoaderBase
implements MaterialLoader {
    protected TextureResolver textureResolver;
    private Array<Material> materials = new Array();
    private Material defaultMaterial;

    public MaterialLoaderBase(TextureResolver textureResolver, Material defaultMaterial) {
        this.textureResolver = textureResolver;
        this.defaultMaterial = defaultMaterial;
    }

    @Override
    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }

    @Override
    public Material get(int index) {
        return (Material)this.materials.get(index);
    }

    @Override
    public void loadMaterials(Array<GLTFMaterial> glMaterials) {
        if (glMaterials != null) {
            for (int i = 0; i < glMaterials.size; ++i) {
                GLTFMaterial glMaterial = (GLTFMaterial)glMaterials.get(i);
                Material material = this.loadMaterial(glMaterial);
                this.materials.add((Object)material);
            }
        }
    }

    protected abstract Material loadMaterial(GLTFMaterial var1);
}

